/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.resultSet.impl;

import org.apache.drill.exec.physical.resultSet.impl.TupleState;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.vector.accessor.ObjectWriter;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.exec.vector.accessor.VariantWriter;
import org.apache.drill.exec.vector.accessor.writer.RepeatedListWriter;

public class BuildFromSchema {
    private static BuildFromSchema instance = new BuildFromSchema();

    private BuildFromSchema() {
    }

    public static BuildFromSchema instance() {
        return instance;
    }

    public void buildTuple(TupleWriter writer, TupleMetadata schema) {
        TupleShim tupleShim = new TupleShim(writer);
        for (int i = 0; i < schema.size(); ++i) {
            ColumnMetadata colSchema = schema.metadata(i);
            this.buildColumn(tupleShim, colSchema);
        }
    }

    public ObjectWriter buildColumn(TupleState state, ColumnMetadata colSchema) {
        return this.buildColumn(new TupleStateShim(state), colSchema);
    }

    private ObjectWriter buildColumn(ParentShim parent, ColumnMetadata colSchema) {
        if (colSchema.isMultiList()) {
            return this.buildRepeatedList(parent, colSchema);
        }
        if (colSchema.isMap()) {
            return this.buildMap(parent, colSchema);
        }
        if (this.isSingleList(colSchema)) {
            return this.buildSingleList(parent, colSchema);
        }
        if (colSchema.isVariant()) {
            return this.buildVariant(parent, colSchema);
        }
        if (colSchema.isDict()) {
            return this.buildDict(parent, colSchema);
        }
        return this.buildPrimitive(parent, colSchema);
    }

    private boolean isSingleList(ColumnMetadata colSchema) {
        return colSchema.isVariant() && colSchema.isArray() && colSchema.variantSchema().isSingleType();
    }

    private ObjectWriter buildPrimitive(ParentShim parent, ColumnMetadata colSchema) {
        return parent.add(colSchema);
    }

    private ObjectWriter buildMap(ParentShim parent, ColumnMetadata colSchema) {
        ObjectWriter colWriter = parent.add(colSchema.cloneEmpty());
        this.expandMap(colWriter, colSchema);
        return colWriter;
    }

    private void expandMap(ObjectWriter colWriter, ColumnMetadata colSchema) {
        if (colSchema.isArray()) {
            this.buildTuple(colWriter.array().tuple(), colSchema.tupleSchema());
        } else {
            this.buildTuple(colWriter.tuple(), colSchema.tupleSchema());
        }
    }

    private ObjectWriter buildVariant(ParentShim parent, ColumnMetadata colSchema) {
        ObjectWriter colWriter = parent.add(colSchema.cloneEmpty());
        this.expandVariant(colWriter, colSchema);
        return colWriter;
    }

    private void expandVariant(ObjectWriter colWriter, ColumnMetadata colSchema) {
        if (colSchema.isArray()) {
            this.buildUnion(colWriter.array().variant(), colSchema.variantSchema());
        } else {
            this.buildUnion(colWriter.variant(), colSchema.variantSchema());
        }
    }

    public void buildUnion(VariantWriter writer, VariantMetadata schema) {
        UnionShim unionShim = new UnionShim(writer);
        for (ColumnMetadata member : schema.members()) {
            this.buildColumn(unionShim, member);
        }
    }

    private ObjectWriter buildSingleList(ParentShim parent, ColumnMetadata colSchema) {
        ColumnMetadata seed = colSchema.cloneEmpty();
        ColumnMetadata subtype = colSchema.variantSchema().listSubtype();
        seed.variantSchema().addType(subtype.cloneEmpty());
        seed.variantSchema().becomeSimple();
        ObjectWriter listWriter = parent.add(seed);
        this.expandColumn(listWriter, subtype);
        return listWriter;
    }

    private ObjectWriter buildRepeatedList(ParentShim parent, ColumnMetadata colSchema) {
        ObjectWriter objWriter = parent.add(colSchema.cloneEmpty());
        RepeatedListWriter listWriter = (RepeatedListWriter)objWriter.array();
        ColumnMetadata elements = colSchema.childSchema();
        if (elements != null) {
            RepeatedListShim listShim = new RepeatedListShim(listWriter);
            this.buildColumn(listShim, elements);
        }
        return objWriter;
    }

    private void expandColumn(ObjectWriter colWriter, ColumnMetadata colSchema) {
        if (colSchema.isMultiList()) {
            assert (false);
        } else if (colSchema.isMap()) {
            this.expandMap(colWriter, colSchema);
        } else if (this.isSingleList(colSchema)) {
            assert (false);
        } else if (colSchema.isVariant()) {
            this.expandVariant(colWriter, colSchema);
        } else if (colSchema.isDict()) {
            this.expandDict(colWriter, colSchema);
        }
    }

    private ObjectWriter buildDict(ParentShim parent, ColumnMetadata colSchema) {
        ObjectWriter colWriter = parent.add(colSchema.cloneEmpty());
        this.expandDict(colWriter, colSchema);
        return colWriter;
    }

    private void expandDict(ObjectWriter colWriter, ColumnMetadata colSchema) {
        if (colSchema.isArray()) {
            this.buildTuple(colWriter.array().dict().tuple(), colSchema.tupleSchema());
        } else {
            this.buildTuple(colWriter.dict().tuple(), colSchema.tupleSchema());
        }
    }

    private static class TupleShim
    implements ParentShim {
        private final TupleWriter writer;

        public TupleShim(TupleWriter writer) {
            this.writer = writer;
        }

        @Override
        public ObjectWriter add(ColumnMetadata colSchema) {
            int index = this.writer.addColumn(colSchema);
            return this.writer.column(index);
        }
    }

    private static interface ParentShim {
        public ObjectWriter add(ColumnMetadata var1);
    }

    private static class TupleStateShim
    implements ParentShim {
        private final TupleState state;

        public TupleStateShim(TupleState state) {
            this.state = state;
        }

        @Override
        public ObjectWriter add(ColumnMetadata colSchema) {
            return this.state.addColumn(colSchema).writer();
        }
    }

    private static class UnionShim
    implements ParentShim {
        private final VariantWriter writer;

        public UnionShim(VariantWriter writer) {
            this.writer = writer;
        }

        @Override
        public ObjectWriter add(ColumnMetadata colSchema) {
            return this.writer.addMember(colSchema);
        }
    }

    private static class RepeatedListShim
    implements ParentShim {
        private final RepeatedListWriter writer;

        public RepeatedListShim(RepeatedListWriter writer) {
            this.writer = writer;
        }

        @Override
        public ObjectWriter add(ColumnMetadata colSchema) {
            return this.writer.defineElement(colSchema);
        }
    }
}

