/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.cache.VectorSerializer;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.spill.SpillSet;
import org.apache.drill.exec.physical.impl.xsort.BatchGroup;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;

public class SpilledRun
extends BatchGroup {
    private InputStream inputStream;
    private final String path;
    private final SpillSet spillSet;
    private final BufferAllocator allocator;
    private int spilledBatches;
    private long batchSizeBytes;
    private VectorSerializer.Writer writer;
    private VectorSerializer.Reader reader;

    public SpilledRun(SpillSet spillSet, String path, BufferAllocator allocator) throws IOException {
        super(null, allocator);
        this.spillSet = spillSet;
        this.path = path;
        this.allocator = allocator;
        this.writer = spillSet.writer(path);
    }

    public void spillBatch(VectorContainer newContainer) throws IOException {
        this.writer.write(newContainer);
        newContainer.zeroVectors();
        logger.trace("Wrote {} records in {} us", (Object)newContainer.getRecordCount(), (Object)this.writer.time(TimeUnit.MICROSECONDS));
        ++this.spilledBatches;
        this.currentContainer = newContainer;
        this.currentContainer.setEmpty();
    }

    public void setBatchSize(long batchSize) {
        this.batchSizeBytes = batchSize;
    }

    public long getBatchSize() {
        return this.batchSizeBytes;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int getNextIndex() {
        if (this.mergeIndex == this.getRecordCount()) {
            if (this.spilledBatches == 0) {
                return -1;
            }
            this.readBatch();
            this.mergeIndex = 1;
            return 0;
        }
        return super.getNextIndex();
    }

    private void readBatch() {
        try {
            if (this.inputStream == null) {
                this.inputStream = this.spillSet.openForInput(this.path);
                this.reader = VectorSerializer.reader(this.allocator, this.inputStream);
            }
            Stopwatch watch = Stopwatch.createStarted();
            long start = this.allocator.getAllocatedMemory();
            VectorContainer c = this.reader.read();
            long end = this.allocator.getAllocatedMemory();
            logger.trace("Read {} records in {} us; size = {}, memory = {}", new Object[]{c.getRecordCount(), watch.elapsed(TimeUnit.MICROSECONDS), end - start, end});
            if (this.schema != null) {
                c = SchemaUtil.coerceContainer((VectorAccessible)c, this.schema, this.allocator);
            }
            --this.spilledBatches;
            this.currentContainer.zeroVectors();
            Iterator<VectorWrapper<?>> wrapperIterator = c.iterator();
            for (VectorWrapper<?> w : this.currentContainer) {
                TransferPair pair = wrapperIterator.next().getValueVector().makeTransferPair((ValueVector)w.getValueVector());
                pair.transfer();
            }
            this.currentContainer.setRecordCount(c.getRecordCount());
            c.zeroVectors();
        }
        catch (IOException e) {
            this.currentContainer.clear();
            throw UserException.dataReadError(e).message("Failure while reading spilled data", new Object[0]).build(logger);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            AutoCloseables.close(() -> super.close(), this::closeWriter, this::closeInputStream, () -> this.spillSet.delete(this.path));
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    private void closeInputStream() throws IOException {
        if (this.inputStream == null) {
            return;
        }
        long readLength = this.spillSet.getPosition(this.inputStream);
        this.spillSet.tallyReadBytes(readLength);
        this.inputStream.close();
        this.inputStream = null;
        this.reader = null;
        logger.trace("Summary: Read {} bytes from {}", (Object)readLength, (Object)this.path);
    }

    public void closeWriter() throws IOException {
        if (this.writer != null) {
            this.spillSet.close(this.writer);
            logger.trace("Summary: Wrote {} bytes in {} us to {}", new Object[]{this.writer.getBytesWritten(), this.writer.time(TimeUnit.MICROSECONDS), this.path});
            this.writer = null;
        }
    }
}

