/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.impl.xsort.ExternalSortBatch;

public class SortMetrics {
    private int peakBatchCount = -1;
    private int inputRecordCount = 0;
    private int inputBatchCount = 0;
    private long totalInputBytes;
    private long minimumBufferSpace;
    private OperatorStats stats;
    private int spillCount;
    private int mergeCount;
    private long writeBytes;

    public SortMetrics(OperatorStats stats) {
        assert (stats != null);
        this.stats = stats;
    }

    public void updateInputMetrics(int rowCount, long batchSize) {
        this.inputRecordCount += rowCount;
        ++this.inputBatchCount;
        this.totalInputBytes += batchSize;
    }

    public void updateMemory(long freeMem) {
        this.minimumBufferSpace = this.minimumBufferSpace == 0L ? freeMem : Math.min(this.minimumBufferSpace, freeMem);
        this.stats.setLongStat(ExternalSortBatch.Metric.MIN_BUFFER, this.minimumBufferSpace);
    }

    public int getInputRowCount() {
        return this.inputRecordCount;
    }

    public long getInputBatchCount() {
        return this.inputBatchCount;
    }

    public long getInputBytes() {
        return this.totalInputBytes;
    }

    public void updatePeakBatches(int bufferedBatchCount) {
        if (this.peakBatchCount < bufferedBatchCount) {
            this.peakBatchCount = bufferedBatchCount;
            this.stats.setLongStat(ExternalSortBatch.Metric.PEAK_BATCHES_IN_MEMORY, this.peakBatchCount);
        }
    }

    public void incrMergeCount() {
        this.stats.addLongStat(ExternalSortBatch.Metric.MERGE_COUNT, 1L);
        ++this.mergeCount;
    }

    public void incrSpillCount() {
        this.stats.addLongStat(ExternalSortBatch.Metric.SPILL_COUNT, 1L);
        ++this.spillCount;
    }

    public void updateWriteBytes(long writeBytes) {
        this.stats.setDoubleStat(ExternalSortBatch.Metric.SPILL_MB, (double)writeBytes / 1024.0 / 1024.0);
        this.writeBytes = writeBytes;
    }

    public int getSpillCount() {
        return this.spillCount;
    }

    public int getMergeCount() {
        return this.mergeCount;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public int getPeakBatchCount() {
        return this.peakBatchCount;
    }
}

