/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.server.options.OptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortConfig {
    private static final Logger logger = LoggerFactory.getLogger(SortConfig.class);
    public static final int MIN_MERGED_BATCH_SIZE = 262144;
    public static final long MIN_SPILL_FILE_SIZE = 0x100000L;
    public static final int DEFAULT_SPILL_BATCH_SIZE = 0x800000;
    public static final int MIN_SPILL_BATCH_SIZE = 262144;
    public static final int MIN_MERGE_BATCH_SIZE = 262144;
    public static final int DEFAULT_MERGE_LIMIT = 128;
    public static final int MIN_MERGE_LIMIT = 2;
    private final long maxMemory;
    private final int mergeLimit;
    private final long spillFileSize;
    private final int spillBatchSize;
    private final int mergeBatchSize;
    private final int bufferedBatchLimit;
    private final int mSortBatchSize;

    public SortConfig(DrillConfig config, OptionManager options) {
        this.maxMemory = config.getBytes("drill.exec.sort.external.mem_limit");
        int limit = config.getInt("drill.exec.sort.external.merge_limit");
        this.mergeLimit = limit > 0 ? Math.max(limit, 2) : Integer.MAX_VALUE;
        this.spillFileSize = Math.max(config.getBytes("drill.exec.sort.external.spill.file_size"), 0x100000L);
        this.spillBatchSize = (int)Math.max(config.getBytes("drill.exec.sort.external.spill.spill_batch_size"), 262144L);
        this.mergeBatchSize = (int)Math.max(options.getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR), 262144L);
        int value = config.getInt("drill.exec.sort.external.batch_limit");
        this.bufferedBatchLimit = value == 0 ? Integer.MAX_VALUE : Math.max(value, 2);
        this.mSortBatchSize = config.hasPath("drill.exec.sort.external.msort.batch.maxsize") ? Math.max(1, Math.min(65535, config.getInt("drill.exec.sort.external.msort.batch.maxsize"))) : 65535;
        this.logConfig();
    }

    private void logConfig() {
        logger.debug("Config: spill file size = {}, spill batch size = {}, merge batch size = {}, mSort batch size = {}", new Object[]{this.spillFileSize, this.spillBatchSize, this.mergeBatchSize, this.mSortBatchSize});
    }

    public String toString() {
        return "SortConfig[spillFileSize=" + this.spillFileSize + ", spillBatchSize=" + this.spillBatchSize + ", mergeBatchSize=" + this.mergeBatchSize + ", mSortBatchSize=" + this.mSortBatchSize + "]";
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public int mergeLimit() {
        return this.mergeLimit;
    }

    public long spillFileSize() {
        return this.spillFileSize;
    }

    public int spillBatchSize() {
        return this.spillBatchSize;
    }

    public int mergeBatchSize() {
        return this.mergeBatchSize;
    }

    public int getBufferedBatchLimit() {
        return this.bufferedBatchLimit;
    }

    public int getMSortBatchSize() {
        return this.mSortBatchSize;
    }
}

