/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.xsort.BaseSortWrapper;
import org.apache.drill.exec.physical.impl.xsort.BatchGroup;
import org.apache.drill.exec.physical.impl.xsort.PriorityQueueCopier;
import org.apache.drill.exec.physical.impl.xsort.SortImpl;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorInitializer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.vector.CopyUtil;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityQueueCopierWrapper
extends BaseSortWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PriorityQueueCopierWrapper.class);
    private static final GeneratorMapping COPIER_MAPPING = new GeneratorMapping("doSetup", "doCopy", null, null);
    private final MappingSet COPIER_MAPPING_SET = new MappingSet(COPIER_MAPPING, COPIER_MAPPING);
    private PriorityQueueCopier copier;

    public PriorityQueueCopierWrapper(OperatorContext opContext) {
        super(opContext);
    }

    public PriorityQueueCopier getCopier(VectorAccessible batch) {
        if (this.copier == null) {
            this.copier = this.newCopier(batch);
        }
        return this.copier;
    }

    private PriorityQueueCopier newCopier(VectorAccessible batch) {
        CodeGenerator<PriorityQueueCopier> cg = CodeGenerator.get(PriorityQueueCopier.TEMPLATE_DEFINITION, this.context.getFragmentContext().getOptions());
        ClassGenerator<PriorityQueueCopier> g = cg.getRoot();
        cg.plainJavaCapable(true);
        this.generateComparisons(g, batch, logger);
        g.setMappingSet(this.COPIER_MAPPING_SET);
        CopyUtil.generateCopies(g, batch, true);
        g.setMappingSet(this.MAIN_MAPPING);
        return this.getInstance(cg, logger);
    }

    public BatchMerger startMerge(BatchSchema schema, List<? extends BatchGroup> batchGroupList, VectorContainer outputContainer, int targetRecordCount, VectorInitializer allocHelper) {
        return new BatchMerger(this, schema, batchGroupList, outputContainer, targetRecordCount, allocHelper);
    }

    private void createCopier(VectorAccessible batch, List<? extends BatchGroup> batchGroupList, VectorContainer outputContainer) {
        this.copier = this.getCopier(batch);
        for (VectorWrapper i : batch) {
            ValueVector v = TypeHelper.getNewVector(i.getField(), this.context.getAllocator());
            outputContainer.add(v);
        }
        try {
            this.copier.setup(this.context.getAllocator(), batch, batchGroupList, outputContainer);
        }
        catch (SchemaChangeException e) {
            throw UserException.unsupportedError(e).message("Unexpected schema change - likely code error.", new Object[0]).build(logger);
        }
        logger.debug("Copier setup complete");
    }

    public BufferAllocator getAllocator() {
        return this.context.getAllocator();
    }

    public void close() {
        if (this.copier == null) {
            return;
        }
        try {
            this.copier.close();
            this.copier = null;
        }
        catch (IOException e) {
            throw UserException.dataWriteError(e).message("Failure while flushing spilled data", new Object[0]).build(logger);
        }
    }

    public static class BatchMerger
    implements SortImpl.SortResults,
    AutoCloseable {
        private final PriorityQueueCopierWrapper holder;
        private final VectorContainer hyperBatch;
        private final VectorContainer outputContainer;
        private final VectorInitializer allocHelper;
        private final int targetRecordCount;
        private int batchCount;
        private long estBatchSize;

        private BatchMerger(PriorityQueueCopierWrapper holder, BatchSchema schema, List<? extends BatchGroup> batchGroupList, int targetRecordCount, VectorInitializer allocHelper) {
            this(holder, schema, batchGroupList, new VectorContainer(), targetRecordCount, allocHelper);
        }

        private BatchMerger(PriorityQueueCopierWrapper holder, BatchSchema schema, List<? extends BatchGroup> batchGroupList, VectorContainer outputContainer, int targetRecordCount, VectorInitializer allocHelper) {
            this.holder = holder;
            this.allocHelper = allocHelper;
            this.hyperBatch = this.constructHyperBatch(schema, batchGroupList);
            this.targetRecordCount = targetRecordCount;
            this.outputContainer = outputContainer;
            holder.createCopier(this.hyperBatch, batchGroupList, outputContainer);
        }

        @Override
        public boolean next() {
            long start = this.holder.getAllocator().getAllocatedMemory();
            if (this.allocHelper == null) {
                VectorAccessibleUtilities.allocateVectors(this.outputContainer, this.targetRecordCount);
            } else {
                this.allocHelper.allocateBatch(this.outputContainer, this.targetRecordCount);
            }
            logger.trace("Initial output batch allocation: {} bytes, {} records", (Object)(this.holder.getAllocator().getAllocatedMemory() - start), (Object)this.targetRecordCount);
            Stopwatch w = Stopwatch.createStarted();
            int count = this.holder.copier.next(this.targetRecordCount);
            if (count > 0) {
                long t = w.elapsed(TimeUnit.MICROSECONDS);
                ++this.batchCount;
                long size = this.holder.getAllocator().getAllocatedMemory() - start;
                logger.trace("Took {} us to merge {} records, consuming {} bytes of memory", new Object[]{t, count, size});
                this.estBatchSize = Math.max(this.estBatchSize, size);
            } else {
                logger.trace("copier returned 0 records");
            }
            this.outputContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            this.outputContainer.setRecordCount(count);
            return count > 0;
        }

        private VectorContainer constructHyperBatch(BatchSchema schema, List<? extends BatchGroup> batchGroupList) {
            VectorContainer cont = new VectorContainer();
            for (MaterializedField field : schema) {
                ValueVector[] vectors = new ValueVector[batchGroupList.size()];
                int i = 0;
                for (BatchGroup batchGroup : batchGroupList) {
                    vectors[i++] = batchGroup.getValueAccessorById(field.getValueClass(), batchGroup.getValueVectorId(SchemaPath.getSimplePath(field.getName())).getFieldIds()).getValueVector();
                }
                cont.add(vectors);
            }
            cont.buildSchema(BatchSchema.SelectionVectorMode.FOUR_BYTE);
            return cont;
        }

        @Override
        public void close() {
            this.hyperBatch.clear();
            this.holder.close();
        }

        @Override
        public int getRecordCount() {
            return this.outputContainer.getRecordCount();
        }

        @Override
        public int getBatchCount() {
            return this.batchCount;
        }

        public long getEstBatchSize() {
            return this.estBatchSize;
        }

        @Override
        public SelectionVector4 getSv4() {
            return null;
        }

        @Override
        public void updateOutputContainer(VectorContainer container, SelectionVector4 sv4, RecordBatch.IterOutcome outcome, BatchSchema schema) {
            if (outcome == RecordBatch.IterOutcome.EMIT) {
                throw new UnsupportedOperationException("It looks like Sort is hitting memory pressure and forced to spill for cases with EMIT outcome. This Sort is most likely used within the subquery between Lateral and Unnest in which case spilling is unexpected.");
            }
            VectorContainer dataContainer = this.getContainer();
            if (container.getNumberOfColumns() == 0) {
                for (VectorWrapper<?> vw : dataContainer) {
                    container.add((ValueVector)vw.getValueVector());
                }
                container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            } else {
                container.transferIn(dataContainer);
            }
            container.setRecordCount(this.getRecordCount());
        }

        @Override
        public SelectionVector2 getSv2() {
            return null;
        }

        @Override
        public VectorContainer getContainer() {
            return this.outputContainer;
        }
    }
}

