/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.xsort.BatchGroup;
import org.apache.drill.exec.physical.impl.xsort.PriorityQueueCopier;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.selection.SelectionVector4;

public abstract class PriorityQueueCopierTemplate
implements PriorityQueueCopier {
    private SelectionVector4 vector4;
    private List<BatchGroup> batchGroups;
    private VectorAccessible hyperBatch;
    private VectorAccessible outgoing;
    private int size;
    private int queueSize;

    @Override
    public void setup(BufferAllocator allocator, VectorAccessible hyperBatch, List<BatchGroup> batchGroups, VectorAccessible outgoing) throws SchemaChangeException {
        this.hyperBatch = hyperBatch;
        this.batchGroups = batchGroups;
        this.outgoing = outgoing;
        this.size = batchGroups.size();
        DrillBuf drillBuf = allocator.buffer(4 * this.size);
        this.vector4 = new SelectionVector4(drillBuf, this.size, 65535);
        this.doSetup(hyperBatch, outgoing);
        this.queueSize = 0;
        for (int i = 0; i < this.size; ++i) {
            int index = batchGroups.get(i).getNextIndex();
            this.vector4.set(i, i, index);
            if (index <= -1) continue;
            this.siftUp();
            ++this.queueSize;
        }
    }

    @Override
    public int next(int targetRecordCount) {
        try {
            for (int outgoingIndex = 0; outgoingIndex < targetRecordCount; ++outgoingIndex) {
                if (this.queueSize == 0) {
                    return 0;
                }
                int compoundIndex = this.vector4.get(0);
                int batch = compoundIndex >>> 16;
                assert (batch < this.batchGroups.size()) : String.format("batch: %d batchGroups: %d", batch, this.batchGroups.size());
                this.doCopy(compoundIndex, outgoingIndex);
                int nextIndex = this.batchGroups.get(batch).getNextIndex();
                if (nextIndex < 0) {
                    this.vector4.set(0, this.vector4.get(--this.queueSize));
                } else {
                    this.vector4.set(0, batch, nextIndex);
                }
                if (this.queueSize == 0) {
                    VectorAccessibleUtilities.setValueCount(this.outgoing, ++outgoingIndex);
                    return outgoingIndex;
                }
                this.siftDown();
            }
            VectorAccessibleUtilities.setValueCount(this.outgoing, targetRecordCount);
            return targetRecordCount;
        }
        catch (SchemaChangeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.vector4.clear();
        VectorAccessibleUtilities.clear(this.outgoing);
        VectorAccessibleUtilities.clear(this.hyperBatch);
        BatchGroup.closeAll(this.batchGroups);
    }

    private void siftUp() throws SchemaChangeException {
        int p = this.queueSize;
        while (p > 0 && this.compare(p, (p - 1) / 2) < 0) {
            this.swap(p, (p - 1) / 2);
            p = (p - 1) / 2;
        }
    }

    private void siftDown() throws SchemaChangeException {
        int next;
        int p = 0;
        while (p * 2 + 1 < this.queueSize && this.compare(p, next = p * 2 + 2 >= this.queueSize ? p * 2 + 1 : (this.compare(p * 2 + 1, p * 2 + 2) <= 0 ? p * 2 + 1 : p * 2 + 2)) > 0) {
            this.swap(p, next);
            p = next;
        }
    }

    public void swap(int sv0, int sv1) {
        int tmp = this.vector4.get(sv0);
        this.vector4.set(sv0, this.vector4.get(sv1));
        this.vector4.set(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) throws SchemaChangeException {
        int sv1 = this.vector4.get(leftIndex);
        int sv2 = this.vector4.get(rightIndex);
        return this.doEval(sv1, sv2);
    }

    public abstract void doSetup(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract int doEval(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2) throws SchemaChangeException;

    public abstract void doCopy(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;
}

