/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import io.netty.buffer.DrillBuf;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.xsort.MSorter;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Queues;
import org.apache.hadoop.util.IndexedSortable;

public abstract class MSortTemplate
implements MSorter,
IndexedSortable {
    private SelectionVector4 vector4;
    private SelectionVector4 aux;
    private long compares;
    private Queue<Integer> runStarts = Queues.newLinkedBlockingQueue();
    private FragmentContext context;
    private int desiredRecordBatchCount;

    @Override
    public void setup(FragmentContext context, BufferAllocator allocator, SelectionVector4 vector4, VectorContainer hyperBatch, int outputBatchSize, int desiredBatchSize) throws SchemaChangeException {
        Preconditions.checkNotNull(vector4);
        this.vector4 = vector4.createNewWrapperCurrent();
        this.context = context;
        vector4.clear();
        this.doSetup(context, hyperBatch, null);
        this.runStarts.add(0);
        int batch = 0;
        int totalCount = this.vector4.getTotalCount();
        for (int i = 0; i < totalCount; ++i) {
            int newBatch = this.vector4.get(i) >>> 16;
            if (newBatch == batch) continue;
            if (newBatch == batch + 1) {
                this.runStarts.add(i);
                batch = newBatch;
                continue;
            }
            throw new UnsupportedOperationException(String.format("Missing batch. batch: %d newBatch: %d", batch, newBatch));
        }
        DrillBuf drillBuf = allocator.buffer(4 * totalCount);
        this.desiredRecordBatchCount = Math.min(outputBatchSize, desiredBatchSize);
        this.desiredRecordBatchCount = Math.min(this.desiredRecordBatchCount, totalCount);
        this.aux = new SelectionVector4(drillBuf, totalCount, this.desiredRecordBatchCount);
    }

    public static long memoryNeeded(int recordCount) {
        return BaseAllocator.nextPowerOfTwo(recordCount * 4);
    }

    protected int merge(int leftStart, int rightStart, int rightEnd, int outStart) {
        int l = leftStart;
        int r = rightStart;
        int o = outStart;
        while (l < rightStart && r < rightEnd) {
            if (this.compare(l, r) <= 0) {
                this.aux.set(o++, this.vector4.get(l++));
                continue;
            }
            this.aux.set(o++, this.vector4.get(r++));
        }
        while (l < rightStart) {
            this.aux.set(o++, this.vector4.get(l++));
        }
        while (r < rightEnd) {
            this.aux.set(o++, this.vector4.get(r++));
        }
        assert (o == outStart + (rightEnd - leftStart));
        return o;
    }

    @Override
    public SelectionVector4 getSV4() {
        return this.vector4;
    }

    @Override
    public void sort() {
        while (this.runStarts.size() > 1) {
            int totalCount = this.vector4.getTotalCount();
            this.context.getExecutorState().checkContinue();
            int outIndex = 0;
            LinkedBlockingQueue<Integer> newRunStarts = Queues.newLinkedBlockingQueue();
            newRunStarts.add(outIndex);
            int size = this.runStarts.size();
            for (int i = 0; i < size / 2; ++i) {
                int left = this.runStarts.poll();
                int right = this.runStarts.poll();
                Integer end = this.runStarts.peek();
                if (end == null) {
                    end = totalCount;
                }
                if ((outIndex = this.merge(left, right, end, outIndex)) >= this.vector4.getTotalCount()) continue;
                newRunStarts.add(outIndex);
            }
            if (outIndex < totalCount) {
                this.copyRun(outIndex, totalCount);
            }
            SelectionVector4 tmp = this.aux.createNewWrapperCurrent(this.desiredRecordBatchCount);
            this.aux.clear();
            this.aux = this.vector4.createNewWrapperCurrent(this.desiredRecordBatchCount);
            this.vector4.clear();
            this.vector4 = tmp.createNewWrapperCurrent(this.desiredRecordBatchCount);
            tmp.clear();
            this.runStarts = newRunStarts;
        }
        this.aux.clear();
    }

    private void copyRun(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.aux.set(i, this.vector4.get(i));
        }
    }

    public void swap(int sv0, int sv1) {
        int tmp = this.vector4.get(sv0);
        this.vector4.set(sv0, this.vector4.get(sv1));
        this.vector4.set(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) {
        int sv1 = this.vector4.get(leftIndex);
        int sv2 = this.vector4.get(rightIndex);
        ++this.compares;
        try {
            return this.doEval(sv1, sv2);
        }
        catch (SchemaChangeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clear() {
        if (this.vector4 != null) {
            this.vector4.clear();
            this.vector4 = null;
        }
        if (this.aux != null) {
            this.aux.clear();
            this.aux = null;
        }
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorContainer var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract int doEval(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2) throws SchemaChangeException;
}

