/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.io.IOException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.xsort.BatchGroup;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector2;

public class InputBatch
extends BatchGroup {
    private final SelectionVector2 sv2;
    private final long dataSizeBytes;

    public InputBatch(VectorContainer container, SelectionVector2 sv2, BufferAllocator allocator, long dataSize) {
        super(container, allocator);
        this.sv2 = sv2;
        this.dataSizeBytes = dataSize;
    }

    public SelectionVector2 getSv2() {
        return this.sv2;
    }

    public long getDataSize() {
        return this.dataSizeBytes;
    }

    @Override
    public int getRecordCount() {
        if (this.sv2 != null) {
            return this.sv2.getCount();
        }
        return super.getRecordCount();
    }

    @Override
    public int getNextIndex() {
        int val = super.getNextIndex();
        if (val == -1) {
            return val;
        }
        return this.sv2.getIndex(val);
    }

    @Override
    public void close() throws IOException {
        if (this.sv2 != null) {
            this.sv2.clear();
        }
        super.close();
    }
}

