/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.ExternalSort;
import org.apache.drill.exec.physical.impl.spill.SpillSet;
import org.apache.drill.exec.physical.impl.validate.IteratorValidatorBatchIterator;
import org.apache.drill.exec.physical.impl.xsort.PriorityQueueCopierWrapper;
import org.apache.drill.exec.physical.impl.xsort.SortConfig;
import org.apache.drill.exec.physical.impl.xsort.SortImpl;
import org.apache.drill.exec.physical.impl.xsort.SpilledRuns;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSortBatch
extends AbstractRecordBatch<ExternalSort> {
    static final Logger logger = LoggerFactory.getLogger(ExternalSortBatch.class);
    public static final String INTERRUPTION_AFTER_SORT = "after-sort";
    public static final String INTERRUPTION_AFTER_SETUP = "after-setup";
    public static final String INTERRUPTION_WHILE_SPILLING = "spilling";
    public static final String INTERRUPTION_WHILE_MERGING = "merging";
    protected static final ControlsInjector injector = ControlsInjectorFactory.getInjector(ExternalSortBatch.class);
    private boolean retainInMemoryBatchesOnNone;
    private final RecordBatch incoming;
    private BatchSchema schema;
    private SortImpl.SortResults resultsIterator;
    private SortState sortState = SortState.START;
    private final SortConfig sortConfig;
    private SortImpl sortImpl;
    private RecordBatch.IterOutcome lastKnownOutcome;
    private boolean firstBatchOfSchema;
    private final VectorContainer outputWrapperContainer;
    private final SelectionVector4 outputSV4;

    public ExternalSortBatch(ExternalSort popConfig, FragmentContext context, RecordBatch incoming) {
        super(popConfig, context, true);
        this.incoming = incoming;
        this.outputWrapperContainer = new VectorContainer(context.getAllocator());
        this.outputSV4 = new SelectionVector4(context.getAllocator(), 0);
        this.sortConfig = new SortConfig(context.getConfig(), context.getOptions());
        this.oContext.setInjector(injector);
        this.sortImpl = this.createNewSortImpl();
        this.resultsIterator = new SortImpl.EmptyResults(this.outputWrapperContainer);
    }

    @Override
    public int getRecordCount() {
        return this.resultsIterator.getRecordCount();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        return this.outputSV4;
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        return this.resultsIterator.getSv2();
    }

    @Override
    public void buildSchema() {
        RecordBatch.IterOutcome outcome = this.next(this.incoming);
        switch (outcome) {
            case OK: 
            case OK_NEW_SCHEMA: {
                for (VectorWrapper w : this.incoming) {
                    Object v = this.container.addOrGet(w.getField());
                    if (v instanceof AbstractContainerVector) {
                        w.getValueVector().makeTransferPair((ValueVector)v);
                        v.clear();
                    }
                    v.allocateNew();
                }
                this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                this.container.setRecordCount(0);
                break;
            }
            case NONE: {
                this.state = AbstractRecordBatch.BatchState.DONE;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected iter outcome: " + (Object)((Object)outcome));
            }
        }
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        switch (this.sortState) {
            case DONE: {
                return RecordBatch.IterOutcome.NONE;
            }
            case START: {
                return this.load();
            }
            case LOAD: {
                if (!this.retainInMemoryBatchesOnNone) {
                    this.resetSortState();
                }
                return this.sortState == SortState.DONE ? RecordBatch.IterOutcome.NONE : this.load();
            }
            case DELIVER: {
                return this.nextOutputBatch();
            }
        }
        throw new IllegalStateException("Unexpected sort state: " + (Object)((Object)this.sortState));
    }

    private RecordBatch.IterOutcome nextOutputBatch() {
        this.outputSV4.next();
        if (this.resultsIterator.next()) {
            this.container.setRecordCount(this.getRecordCount());
            injector.injectUnchecked(this.context.getExecutionControls(), INTERRUPTION_WHILE_MERGING);
        }
        return this.getFinalOutcome();
    }

    private RecordBatch.IterOutcome load() {
        logger.trace("Start of load phase");
        RecordBatch.IterOutcome result = RecordBatch.IterOutcome.OK;
        block3: while (true) {
            result = this.loadBatch();
            switch (result) {
                case NONE: 
                case EMIT: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
            break;
        }
        this.resultsIterator = this.sortImpl.startMerge();
        if (!this.resultsIterator.next() && result == RecordBatch.IterOutcome.NONE) {
            this.sortState = SortState.DONE;
            return RecordBatch.IterOutcome.NONE;
        }
        this.checkContinue();
        this.prepareOutputContainer(this.resultsIterator);
        return this.getFinalOutcome();
    }

    private RecordBatch.IterOutcome loadBatch() {
        if (this.sortState == SortState.START) {
            this.sortState = SortState.LOAD;
            this.lastKnownOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        } else {
            this.lastKnownOutcome = this.next(this.incoming);
        }
        switch (this.lastKnownOutcome) {
            case NONE: {
                return this.lastKnownOutcome;
            }
            case OK_NEW_SCHEMA: {
                this.firstBatchOfSchema = true;
                this.setupSchema();
            }
            case OK: 
            case EMIT: {
                this.sortImpl.addBatch(this.incoming);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected iter outcome: " + (Object)((Object)this.lastKnownOutcome));
            }
        }
        return this.lastKnownOutcome;
    }

    private void setupSchema() {
        BatchSchema incomingSchema = this.incoming.getSchema();
        if (this.schema == null) {
            this.schema = incomingSchema;
        } else if (!incomingSchema.equals(this.schema)) {
            if (this.unionTypeEnabled) {
                this.schema = SchemaUtil.mergeSchemas(this.schema, incomingSchema);
            } else {
                throw UserException.unsupportedError().message("Schema changes not supported in External Sort. Please enable Union type.", new Object[0]).addContext("Previous schema", this.schema.toString()).addContext("Incoming schema", incomingSchema.toString()).build(logger);
            }
        }
        this.sortImpl.setSchema(this.schema);
    }

    @Override
    public WritableBatch getWritableBatch() {
        throw new UnsupportedOperationException("A sort batch is not writable.");
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    @Override
    public void close() {
        if (this.sortState == SortState.CLOSED) {
            return;
        }
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
            autoCloseableArray[0] = this::releaseResources;
            autoCloseableArray[1] = () -> super.close();
            autoCloseableArray[2] = this.oContext::close;
            AutoCloseables.closeWithUserException(autoCloseableArray);
        }
        finally {
            this.sortState = SortState.CLOSED;
        }
    }

    public static void retainSv4OnNone(RecordBatch incoming) {
        if (incoming instanceof IteratorValidatorBatchIterator) {
            incoming = ((IteratorValidatorBatchIterator)incoming).getIncoming();
        }
        if (incoming instanceof ExternalSortBatch) {
            ((ExternalSortBatch)incoming).retainInMemoryBatchesOnNone = true;
        }
    }

    public static void releaseBatches(RecordBatch incoming) {
        if (incoming instanceof IteratorValidatorBatchIterator) {
            incoming = ((IteratorValidatorBatchIterator)incoming).getIncoming();
        }
        if (incoming instanceof ExternalSortBatch) {
            ExternalSortBatch esb = (ExternalSortBatch)incoming;
            esb.resetSortState();
        }
    }

    private void releaseResources() {
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[5];
            autoCloseableArray[0] = () -> {
                if (this.resultsIterator != null) {
                    this.resultsIterator.close();
                }
            };
            autoCloseableArray[1] = () -> {
                if (this.sortImpl != null) {
                    this.sortImpl.close();
                }
            };
            autoCloseableArray[2] = this.outputWrapperContainer::clear;
            autoCloseableArray[3] = this.outputSV4::clear;
            autoCloseableArray[4] = this.container::zeroVectors;
            AutoCloseables.closeWithUserException(autoCloseableArray);
        }
        finally {
            this.sortImpl = null;
            this.resultsIterator = null;
        }
    }

    private void resetSortState() {
        this.releaseResources();
        if (this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT) {
            this.sortImpl = this.createNewSortImpl();
            this.sortImpl.setSchema(this.schema);
            this.resultsIterator = new SortImpl.EmptyResults(this.outputWrapperContainer);
            this.sortState = SortState.LOAD;
        } else {
            this.sortState = SortState.DONE;
        }
    }

    private void prepareOutputContainer(SortImpl.SortResults sortResults) {
        if (this.firstBatchOfSchema) {
            this.container.clear();
        } else {
            this.container.zeroVectors();
        }
        sortResults.updateOutputContainer(this.container, this.outputSV4, this.lastKnownOutcome, this.schema);
    }

    private RecordBatch.IterOutcome getFinalOutcome() {
        RecordBatch.IterOutcome outcomeToReturn;
        if (this.firstBatchOfSchema) {
            outcomeToReturn = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            this.firstBatchOfSchema = false;
            this.sortState = SortState.DELIVER;
        } else if (this.getRecordCount() == 0) {
            RecordBatch.IterOutcome iterOutcome = outcomeToReturn = this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT ? RecordBatch.IterOutcome.EMIT : RecordBatch.IterOutcome.NONE;
            if (!this.retainInMemoryBatchesOnNone) {
                this.resetSortState();
            }
        } else if (this.lastKnownOutcome == RecordBatch.IterOutcome.EMIT) {
            boolean hasMoreRecords = this.outputSV4.hasNext();
            this.sortState = hasMoreRecords ? SortState.DELIVER : SortState.LOAD;
            outcomeToReturn = hasMoreRecords ? RecordBatch.IterOutcome.OK : RecordBatch.IterOutcome.EMIT;
        } else {
            outcomeToReturn = RecordBatch.IterOutcome.OK;
            this.sortState = SortState.DELIVER;
        }
        return outcomeToReturn;
    }

    private SortImpl createNewSortImpl() {
        SpillSet spillSet = new SpillSet(this.context.getConfig(), this.context.getHandle(), this.popConfig);
        PriorityQueueCopierWrapper copierHolder = new PriorityQueueCopierWrapper(this.oContext);
        SpilledRuns spilledRuns = new SpilledRuns(this.oContext, spillSet, copierHolder);
        return new SortImpl(this.oContext, this.sortConfig, spilledRuns, this.outputWrapperContainer);
    }

    @Override
    public void dump() {
        logger.error("ExternalSortBatch[schema={}, sortState={}, sortConfig={}, outputWrapperContainer={}, outputSV4={}, container={}]", new Object[]{this.schema, this.sortState, this.sortConfig, this.outputWrapperContainer, this.outputSV4, this.container});
    }

    private static enum SortState {
        START,
        LOAD,
        DELIVER,
        DONE,
        CLOSED;

    }

    public static enum Metric implements MetricDef
    {
        SPILL_COUNT,
        NOT_USED,
        PEAK_BATCHES_IN_MEMORY,
        MERGE_COUNT,
        MIN_BUFFER,
        SPILL_MB;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

