/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.xsort;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.SchemaUtil;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchGroup
implements VectorAccessible,
AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(BatchGroup.class);
    protected final BufferAllocator allocator;
    protected VectorContainer currentContainer;
    protected int mergeIndex;
    protected BatchSchema schema;

    public BatchGroup(VectorContainer container, BufferAllocator allocator) {
        this.currentContainer = container;
        this.allocator = allocator;
    }

    public void setSchema(BatchSchema schema) {
        this.currentContainer = SchemaUtil.coerceContainer((VectorAccessible)this.currentContainer, schema, this.allocator);
        this.schema = schema;
    }

    public int getNextIndex() {
        if (this.mergeIndex == this.getRecordCount()) {
            return -1;
        }
        int val = this.mergeIndex++;
        assert (val < this.currentContainer.getRecordCount());
        return val;
    }

    public VectorContainer getContainer() {
        return this.currentContainer;
    }

    @Override
    public void close() throws IOException {
        this.currentContainer.zeroVectors();
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.currentContainer.getValueAccessorById(clazz, ids);
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.currentContainer.getValueVectorId(path);
    }

    @Override
    public BatchSchema getSchema() {
        return this.currentContainer.getSchema();
    }

    @Override
    public int getRecordCount() {
        return this.currentContainer.getRecordCount();
    }

    public int getUnfilteredRecordCount() {
        return this.currentContainer.getRecordCount();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.currentContainer.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    public static void closeAll(Collection<? extends BatchGroup> groups) {
        try {
            AutoCloseables.close(groups);
        }
        catch (Exception e) {
            throw UserException.dataWriteError(e).message("Failure while flushing spilled data", new Object[0]).build(logger);
        }
    }
}

