/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JVar;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionLookupContext;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.physical.impl.window.WindowFramer;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WindowFunction {
    private static final Logger logger = LoggerFactory.getLogger(WindowFunction.class);
    final Type type;

    WindowFunction(Type type) {
        this.type = type;
    }

    static WindowFunction fromExpression(FunctionCall call) {
        Type type;
        String name = call.getName();
        try {
            type = Type.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            type = Type.AGGREGATE;
        }
        switch (type) {
            case AGGREGATE: {
                return new WindowAggregate();
            }
            case LEAD: {
                return new Lead();
            }
            case LAG: {
                return new Lag();
            }
            case FIRST_VALUE: {
                return new FirstValue();
            }
            case LAST_VALUE: {
                return new LastValue();
            }
            case NTILE: {
                return new Ntile();
            }
        }
        return new Ranking(type);
    }

    abstract void generateCode(ClassGenerator<WindowFramer> var1);

    abstract boolean supportsCustomFrames();

    public boolean requiresFullPartition(WindowPOP pop) {
        return true;
    }

    public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
        return partitionEndReached;
    }

    abstract boolean materialize(NamedExpression var1, VectorContainer var2, FunctionLookupContext var3) throws SchemaChangeException;

    public static enum Type {
        ROW_NUMBER,
        RANK,
        DENSE_RANK,
        PERCENT_RANK,
        CUME_DIST,
        LEAD,
        LAG,
        FIRST_VALUE,
        LAST_VALUE,
        NTILE,
        AGGREGATE;

    }

    static class WindowAggregate
    extends WindowFunction {
        private ValueVectorWriteExpression writeAggregationToOutput;

        WindowAggregate() {
            super(Type.AGGREGATE);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            LogicalExpression aggregate = ExpressionTreeMaterializer.materializeAndCheckErrors(ne.getExpr(), batch, registry);
            if (aggregate == null) {
                return false;
            }
            MaterializedField output = MaterializedField.create(ne.getRef().getAsNamePart().getName(), aggregate.getMajorType());
            batch.addOrGet(output).allocateNew();
            TypedFieldId outputId = batch.getValueVectorId(ne.getRef());
            this.writeAggregationToOutput = new ValueVectorWriteExpression(outputId, aggregate, true);
            return true;
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping EVAL_INSIDE = GeneratorMapping.create("setupEvaluatePeer", "evaluatePeer", null, null);
            GeneratorMapping EVAL_OUTSIDE = GeneratorMapping.create("setupPartition", "outputRow", "resetValues", "cleanup");
            MappingSet mappingSet = new MappingSet("index", "outIndex", EVAL_INSIDE, EVAL_OUTSIDE, EVAL_INSIDE);
            cg.setMappingSet(mappingSet);
            cg.addExpr(this.writeAggregationToOutput);
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return pop.getOrderings().isEmpty() || pop.getEnd().isUnbounded();
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            return partitionEndReached || !this.requiresFullPartition(pop) && frameEndReached;
        }

        @Override
        boolean supportsCustomFrames() {
            return true;
        }
    }

    static class Lead
    extends WindowFunction {
        private LogicalExpression writeInputToLead;

        public Lead() {
            super(Type.LEAD);
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupCopyNext", "copyNext", null, null);
            MappingSet eval = new MappingSet("inIndex", "outIndex", mapping, mapping);
            cg.setMappingSet(eval);
            cg.addExpr(this.writeInputToLead);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            FunctionCall call = (FunctionCall)ne.getExpr();
            LogicalExpression input = ExpressionTreeMaterializer.materializeAndCheckErrors(call.arg(0), batch, registry);
            if (input == null) {
                return false;
            }
            TypeProtos.MajorType majorType = input.getMajorType();
            if (majorType.getMode() == TypeProtos.DataMode.REQUIRED) {
                majorType = Types.optional(majorType.getMinorType());
            }
            MaterializedField output = MaterializedField.create(ne.getRef().getAsNamePart().getName(), majorType);
            batch.addOrGet(output).allocateNew();
            TypedFieldId outputId = batch.getValueVectorId(ne.getRef());
            this.writeInputToLead = new ValueVectorWriteExpression(outputId, input, true);
            return true;
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return false;
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            return partitionEndReached || numBatchesAvailable > 1;
        }

        @Override
        boolean supportsCustomFrames() {
            return false;
        }
    }

    static class Lag
    extends WindowFunction {
        private LogicalExpression writeLagToLag;
        private LogicalExpression writeInputToLag;

        Lag() {
            super(Type.LAG);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            FunctionCall call = (FunctionCall)ne.getExpr();
            LogicalExpression input = ExpressionTreeMaterializer.materializeAndCheckErrors(call.arg(0), batch, registry);
            if (input == null) {
                return false;
            }
            TypeProtos.MajorType majorType = input.getMajorType();
            if (majorType.getMode() == TypeProtos.DataMode.REQUIRED) {
                majorType = Types.optional(majorType.getMinorType());
            }
            MaterializedField output = MaterializedField.create(ne.getRef().getAsNamePart().getName(), majorType);
            batch.addOrGet(output).allocateNew();
            TypedFieldId outputId = batch.getValueVectorId(ne.getRef());
            this.writeInputToLag = new ValueVectorWriteExpression(outputId, input, true);
            this.writeLagToLag = new ValueVectorWriteExpression(outputId, new ValueVectorReadExpression(outputId), true);
            return true;
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupCopyFromInternal", "copyFromInternal", null, null);
            MappingSet mappingSet = new MappingSet("inIndex", "outIndex", mapping, mapping);
            cg.setMappingSet(mappingSet);
            cg.addExpr(this.writeLagToLag);
            mapping = GeneratorMapping.create("setupCopyPrev", "copyPrev", null, null);
            MappingSet eval = new MappingSet("inIndex", "outIndex", mapping, mapping);
            cg.setMappingSet(eval);
            cg.addExpr(this.writeInputToLag);
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return false;
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            assert (numBatchesAvailable > 0) : "canDoWork() should not be called when numBatchesAvailable == 0";
            return true;
        }

        @Override
        boolean supportsCustomFrames() {
            return false;
        }
    }

    static class FirstValue
    extends WindowFunction {
        private LogicalExpression writeInputToFirstValue;
        private LogicalExpression writeFirstValueToFirstValue;

        FirstValue() {
            super(Type.FIRST_VALUE);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            FunctionCall call = (FunctionCall)ne.getExpr();
            LogicalExpression input = ExpressionTreeMaterializer.materializeAndCheckErrors(call.arg(0), batch, registry);
            if (input == null) {
                return false;
            }
            MaterializedField output = MaterializedField.create(ne.getRef().getAsNamePart().getName(), input.getMajorType());
            batch.addOrGet(output).allocateNew();
            TypedFieldId outputId = batch.getValueVectorId(ne.getRef());
            this.writeFirstValueToFirstValue = new ValueVectorWriteExpression(outputId, new ValueVectorReadExpression(outputId), true);
            this.writeInputToFirstValue = new ValueVectorWriteExpression(outputId, input, true);
            return true;
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupSaveFirstValue", "saveFirstValue", null, null);
            MappingSet mappingSet = new MappingSet("index", "0", mapping, mapping);
            cg.setMappingSet(mappingSet);
            cg.addExpr(this.writeInputToFirstValue);
            mapping = GeneratorMapping.create("setupWriteFirstValue", "outputRow", "resetValues", "cleanup");
            mappingSet = new MappingSet("0", "outIndex", mapping, mapping);
            cg.setMappingSet(mappingSet);
            cg.addExpr(this.writeFirstValueToFirstValue);
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return false;
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            assert (numBatchesAvailable > 0) : "canDoWork() should not be called when numBatchesAvailable == 0";
            return true;
        }

        @Override
        boolean supportsCustomFrames() {
            return true;
        }
    }

    static class LastValue
    extends WindowFunction {
        private LogicalExpression writeSourceToLastValue;

        LastValue() {
            super(Type.LAST_VALUE);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            FunctionCall call = (FunctionCall)ne.getExpr();
            LogicalExpression input = ExpressionTreeMaterializer.materializeAndCheckErrors(call.arg(0), batch, registry);
            if (input == null) {
                return false;
            }
            MaterializedField output = MaterializedField.create(ne.getRef().getAsNamePart().getName(), input.getMajorType());
            batch.addOrGet(output).allocateNew();
            TypedFieldId outputId = batch.getValueVectorId(ne.getRef());
            this.writeSourceToLastValue = new ValueVectorWriteExpression(outputId, input, true);
            return true;
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupReadLastValue", "writeLastValue", "resetValues", "cleanup");
            MappingSet mappingSet = new MappingSet("index", "outIndex", mapping, mapping);
            cg.setMappingSet(mappingSet);
            cg.addExpr(this.writeSourceToLastValue);
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return pop.getOrderings().isEmpty() || pop.getEnd().isUnbounded();
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            return partitionEndReached || !this.requiresFullPartition(pop) && frameEndReached;
        }

        @Override
        boolean supportsCustomFrames() {
            return true;
        }
    }

    static class Ntile
    extends Ranking {
        private int numTiles;

        public Ntile() {
            super(Type.NTILE);
        }

        private int numTilesFromExpression(LogicalExpression numTilesExpr) {
            int nt;
            if (numTilesExpr instanceof ValueExpressions.IntExpression && (nt = ((ValueExpressions.IntExpression)numTilesExpr).getInt()) > 0) {
                return nt;
            }
            throw UserException.functionError().message("NTILE only accepts positive integer argument", new Object[0]).build(logger);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            FunctionCall call = (FunctionCall)ne.getExpr();
            LogicalExpression argument = call.arg(0);
            MaterializedField outputField = MaterializedField.create(ne.getRef().getAsNamePart().getName(), argument.getMajorType());
            batch.addOrGet(outputField).allocateNew();
            this.fieldId = batch.getValueVectorId(ne.getRef());
            this.numTiles = this.numTilesFromExpression(argument);
            return true;
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupPartition", "outputRow", "resetValues", "cleanup");
            MappingSet mappingSet = new MappingSet(null, "outIndex", mapping, mapping);
            cg.setMappingSet(mappingSet);
            JVar vv = cg.declareVectorValueSetupAndMember(cg.getMappingSet().getOutgoing(), this.fieldId);
            DirectExpression outIndex = cg.getMappingSet().getValueWriteIndex();
            JInvocation setMethod = vv.invoke("getMutator").invoke("setSafe").arg((JExpression)outIndex).arg(JExpr.direct((String)("partition.ntile(" + this.numTiles + ")")));
            cg.getEvalBlock().add((JStatement)setMethod);
        }
    }

    static class Ranking
    extends WindowFunction {
        protected TypedFieldId fieldId;

        Ranking(Type type) {
            super(type);
        }

        private TypeProtos.MajorType getMajorType() {
            if (this.type == Type.CUME_DIST || this.type == Type.PERCENT_RANK) {
                return Types.required(TypeProtos.MinorType.FLOAT8);
            }
            return Types.required(TypeProtos.MinorType.BIGINT);
        }

        private String getName() {
            return this.type.name().toLowerCase();
        }

        @Override
        void generateCode(ClassGenerator<WindowFramer> cg) {
            GeneratorMapping mapping = GeneratorMapping.create("setupPartition", "outputRow", "resetValues", "cleanup");
            MappingSet mappingSet = new MappingSet(null, "outIndex", mapping, mapping);
            cg.setMappingSet(mappingSet);
            JVar vv = cg.declareVectorValueSetupAndMember(cg.getMappingSet().getOutgoing(), this.fieldId);
            DirectExpression outIndex = cg.getMappingSet().getValueWriteIndex();
            JInvocation setMethod = vv.invoke("getMutator").invoke("setSafe").arg((JExpression)outIndex).arg(JExpr.direct((String)("partition." + this.getName())));
            cg.getEvalBlock().add((JStatement)setMethod);
        }

        @Override
        boolean materialize(NamedExpression ne, VectorContainer batch, FunctionLookupContext registry) throws SchemaChangeException {
            MaterializedField outputField = MaterializedField.create(ne.getRef().getAsNamePart().getName(), this.getMajorType());
            batch.addOrGet(outputField).allocateNew();
            this.fieldId = batch.getValueVectorId(ne.getRef());
            return true;
        }

        @Override
        public boolean requiresFullPartition(WindowPOP pop) {
            return this.type == Type.CUME_DIST || this.type == Type.PERCENT_RANK || this.type == Type.NTILE;
        }

        @Override
        public boolean canDoWork(int numBatchesAvailable, WindowPOP pop, boolean frameEndReached, boolean partitionEndReached) {
            assert (numBatchesAvailable > 0) : "canDoWork() should not be called when numBatchesAvailable == 0";
            if (this.type == Type.ROW_NUMBER) {
                return true;
            }
            if (this.type == Type.RANK) {
                return frameEndReached;
            }
            return partitionEndReached;
        }

        @Override
        boolean supportsCustomFrames() {
            return false;
        }
    }
}

