/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import com.sun.codemodel.JExpr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.TemplateClassDefinition;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.physical.impl.window.WindowDataBatch;
import org.apache.drill.exec.physical.impl.window.WindowFramer;
import org.apache.drill.exec.physical.impl.window.WindowFunction;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowFrameRecordBatch
extends AbstractRecordBatch<WindowPOP> {
    static final Logger logger = LoggerFactory.getLogger(WindowFrameRecordBatch.class);
    private final RecordBatch incoming;
    private List<WindowDataBatch> batches;
    private WindowFramer[] framers;
    private final List<WindowFunction> functions = new ArrayList<WindowFunction>();
    private boolean noMoreBatches;
    private BatchSchema schema;

    public WindowFrameRecordBatch(WindowPOP popConfig, FragmentContext context, RecordBatch incoming) throws OutOfMemoryException {
        super(popConfig, context);
        this.incoming = incoming;
        this.batches = new ArrayList<WindowDataBatch>();
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        logger.trace("innerNext(), noMoreBatches = {}", (Object)this.noMoreBatches);
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        block6: while (!this.noMoreBatches && !this.canDoWork()) {
            RecordBatch.IterOutcome upstream = this.next(this.incoming);
            logger.trace("next(incoming) returned {}", (Object)upstream);
            switch (upstream) {
                case NONE: {
                    this.noMoreBatches = true;
                    continue block6;
                }
                case NOT_YET: {
                    this.cleanup();
                    return upstream;
                }
                case OK_NEW_SCHEMA: {
                    if (!this.incoming.getSchema().equals(this.schema)) {
                        if (this.schema != null) {
                            throw new UnsupportedOperationException("OVER clause doesn't currently support changing schemas.");
                        }
                        this.schema = this.incoming.getSchema();
                    }
                }
                case OK: {
                    if (this.incoming.getRecordCount() <= 0) continue block6;
                    this.batches.add(new WindowDataBatch(this.incoming, this.oContext));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)upstream));
        }
        if (this.batches.isEmpty()) {
            logger.trace("no more batches to handle, we are DONE");
            this.state = AbstractRecordBatch.BatchState.DONE;
            return RecordBatch.IterOutcome.NONE;
        }
        this.doWork();
        if (this.state == AbstractRecordBatch.BatchState.FIRST) {
            this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
        }
        return RecordBatch.IterOutcome.OK;
    }

    private void doWork() {
        WindowDataBatch current = this.batches.get(0);
        int recordCount = current.getRecordCount();
        logger.trace("WindowFramer.doWork() START, num batches {}, current batch has {} rows", (Object)this.batches.size(), (Object)recordCount);
        this.container.allocateNew();
        try {
            for (WindowFramer framer : this.framers) {
                framer.doWork();
            }
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        for (VectorWrapper vw : current) {
            Object v = this.container.addOrGet(vw.getField());
            TransferPair tp = vw.getValueVector().makeTransferPair((ValueVector)v);
            tp.transfer();
        }
        this.container.setValueCount(recordCount);
        current.clear();
        this.batches.remove(0);
        logger.trace("doWork() END");
    }

    private boolean canDoWork() {
        if (this.batches.size() < 2) {
            return false;
        }
        VectorAccessible current = this.batches.get(0);
        int currentSize = current.getRecordCount();
        VectorAccessible last = this.batches.get(this.batches.size() - 1);
        int lastSize = last.getRecordCount();
        try {
            boolean partitionEndReached = !this.framers[0].isSamePartition(currentSize - 1, current, lastSize - 1, last);
            boolean frameEndReached = partitionEndReached || !this.framers[0].isPeer(currentSize - 1, current, lastSize - 1, last);
            for (WindowFunction function : this.functions) {
                if (function.canDoWork(this.batches.size(), (WindowPOP)this.popConfig, frameEndReached, partitionEndReached)) continue;
                return false;
            }
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        return true;
    }

    @Override
    protected void buildSchema() {
        logger.trace("buildSchema()");
        RecordBatch.IterOutcome outcome = this.next(this.incoming);
        switch (outcome) {
            case NONE: {
                this.state = AbstractRecordBatch.BatchState.DONE;
                this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                return;
            }
        }
        try {
            this.createFramers(this.incoming);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        if (this.incoming.getRecordCount() > 0) {
            this.batches.add(new WindowDataBatch(this.incoming, this.oContext));
        }
    }

    private void createFramers(VectorAccessible batch) throws SchemaChangeException {
        assert (this.framers == null) : "createFramer should only be called once";
        logger.trace("creating framer(s)");
        ArrayList<LogicalExpression> keyExprs = new ArrayList<LogicalExpression>();
        ArrayList<LogicalExpression> orderExprs = new ArrayList<LogicalExpression>();
        boolean requireFullPartition = false;
        boolean useDefaultFrame = false;
        boolean useCustomFrame = false;
        this.container.copySchemaFrom(batch);
        for (NamedExpression ne : ((WindowPOP)this.popConfig).getAggregations()) {
            if (!(ne.getExpr() instanceof FunctionCall)) {
                throw UserException.functionError().message("Unsupported window function '%s'", ne.getExpr()).build(logger);
            }
            FunctionCall call = (FunctionCall)ne.getExpr();
            WindowFunction winfun = WindowFunction.fromExpression(call);
            if (!winfun.materialize(ne, this.container, this.context.getFunctionRegistry())) continue;
            this.functions.add(winfun);
            requireFullPartition |= winfun.requiresFullPartition((WindowPOP)this.popConfig);
            if (winfun.supportsCustomFrames()) {
                useCustomFrame = true;
                continue;
            }
            useDefaultFrame = true;
        }
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setRecordCount(0);
        for (NamedExpression ne : ((WindowPOP)this.popConfig).getWithins()) {
            keyExprs.add(ExpressionTreeMaterializer.materializeAndCheckErrors(ne.getExpr(), batch, this.context.getFunctionRegistry()));
        }
        for (Order.Ordering oe : ((WindowPOP)this.popConfig).getOrderings()) {
            orderExprs.add(ExpressionTreeMaterializer.materializeAndCheckErrors(oe.getExpr(), batch, this.context.getFunctionRegistry()));
        }
        int numFramers = useDefaultFrame ? 1 : 0;
        assert ((numFramers += useCustomFrame ? 1 : 0) > 0) : "No framer was needed!";
        this.framers = new WindowFramer[numFramers];
        int index = 0;
        if (useDefaultFrame) {
            this.framers[index] = this.generateFramer(keyExprs, orderExprs, this.functions, false);
            this.framers[index].setup(this.batches, this.container, this.oContext, requireFullPartition, (WindowPOP)this.popConfig);
            ++index;
        }
        if (useCustomFrame) {
            this.framers[index] = this.generateFramer(keyExprs, orderExprs, this.functions, true);
            this.framers[index].setup(this.batches, this.container, this.oContext, requireFullPartition, (WindowPOP)this.popConfig);
        }
    }

    private WindowFramer generateFramer(List<LogicalExpression> keyExprs, List<LogicalExpression> orderExprs, List<WindowFunction> functions, boolean useCustomFrame) {
        TemplateClassDefinition<WindowFramer> definition = useCustomFrame ? WindowFramer.FRAME_TEMPLATE_DEFINITION : WindowFramer.NOFRAME_TEMPLATE_DEFINITION;
        ClassGenerator<WindowFramer> cg = CodeGenerator.getRoot(definition, this.context.getOptions());
        GeneratorMapping IS_SAME_PARTITION_READ = GeneratorMapping.create("isSamePartition", "isSamePartition", null, null);
        MappingSet isaB1 = new MappingSet("b1Index", null, "b1", null, IS_SAME_PARTITION_READ, IS_SAME_PARTITION_READ);
        MappingSet isaB2 = new MappingSet("b2Index", null, "b2", null, IS_SAME_PARTITION_READ, IS_SAME_PARTITION_READ);
        this.setupIsFunction(cg, keyExprs, isaB1, isaB2);
        GeneratorMapping IS_SAME_PEER_READ = GeneratorMapping.create("isPeer", "isPeer", null, null);
        MappingSet isaP1 = new MappingSet("b1Index", null, "b1", null, IS_SAME_PEER_READ, IS_SAME_PEER_READ);
        MappingSet isaP2 = new MappingSet("b2Index", null, "b2", null, IS_SAME_PEER_READ, IS_SAME_PEER_READ);
        this.setupIsFunction(cg, Iterables.concat(keyExprs, orderExprs), isaP1, isaP2);
        for (WindowFunction function : functions) {
            if (function.supportsCustomFrames() != useCustomFrame) continue;
            function.generateCode(cg);
        }
        cg.getBlock("resetValues")._return(JExpr.TRUE);
        CodeGenerator<WindowFramer> codeGen = cg.getCodeGenerator();
        codeGen.plainJavaCapable(true);
        return this.context.getImplementationClass(codeGen);
    }

    private void setupIsFunction(ClassGenerator<WindowFramer> cg, Iterable<LogicalExpression> exprs, MappingSet leftMapping, MappingSet rightMapping) {
        cg.setMappingSet(leftMapping);
        for (LogicalExpression expr : exprs) {
            if (expr == null) continue;
            cg.setMappingSet(leftMapping);
            ClassGenerator.HoldingContainer first = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            cg.setMappingSet(rightMapping);
            ClassGenerator.HoldingContainer second = cg.addExpr(expr, ClassGenerator.BlkCreateMode.FALSE);
            LogicalExpression fh = FunctionGenerationHelper.getOrderingComparatorNullsHigh(first, second, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = cg.addExpr(fh, ClassGenerator.BlkCreateMode.FALSE);
            cg.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
        }
        cg.getEvalBlock()._return(JExpr.TRUE);
    }

    private void cleanup() {
        if (this.framers != null) {
            for (WindowFramer framer : this.framers) {
                framer.cleanup();
            }
            this.framers = null;
        }
        if (this.batches != null) {
            for (WindowDataBatch bd : this.batches) {
                bd.clear();
            }
            this.batches = null;
        }
    }

    @Override
    public void close() {
        this.cleanup();
        super.close();
    }

    @Override
    protected void cancelIncoming() {
        this.incoming.cancel();
    }

    @Override
    public int getRecordCount() {
        return this.framers[0].getOutputCount();
    }

    @Override
    public void dump() {
        logger.error("WindowFrameRecordBatch[container={}, popConfig={}, framers={}, schema={}]", new Object[]{this.container, this.popConfig, Arrays.toString(this.framers), this.schema});
    }
}

