/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Partition {
    private static final Logger logger = LoggerFactory.getLogger(Partition.class);
    private boolean partial;
    private long length;
    private long remaining;
    private long peers;
    public int row_number = 1;
    public int rank;
    public int dense_rank;
    public double percent_rank;
    public double cume_dist;

    public long getRemaining() {
        return this.remaining;
    }

    public long getLength() {
        return this.length;
    }

    public void updateLength(long length, boolean partial) {
        this.length += length;
        this.partial = partial;
        this.remaining += length;
    }

    public void rowAggregated() {
        --this.remaining;
        --this.peers;
        ++this.row_number;
    }

    public void newFrame(long peers) {
        this.peers = peers;
        this.rank = this.row_number;
        ++this.dense_rank;
        this.percent_rank = this.length > 1L ? (double)(this.rank - 1) / (double)(this.length - 1L) : 0.0;
        this.cume_dist = (double)((long)this.rank + peers - 1L) / (double)this.length;
    }

    public boolean isDone() {
        return !this.partial && this.remaining == 0L;
    }

    public int ntile(int numTiles) {
        int out;
        long mod = this.length % (long)numTiles;
        double ceil = Math.ceil((double)this.length / (double)numTiles);
        if ((double)this.row_number <= (double)mod * ceil) {
            out = (int)Math.ceil((double)this.row_number / ceil);
        } else {
            double floor = Math.floor((double)this.length / (double)numTiles);
            out = (int)Math.ceil((double)((long)this.row_number - mod) / floor);
        }
        logger.trace("NTILE(row_number = {}, nt = {}, ct = {}) = {}", new Object[]{this.row_number, numTiles, this.length, out});
        return out;
    }

    public boolean isFrameDone() {
        return this.peers == 0L;
    }

    public String toString() {
        return String.format("{length: %d, remaining partition: %d, remaining peers: %d}", this.length, this.remaining, this.peers);
    }
}

