/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.window;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.physical.impl.window.Partition;
import org.apache.drill.exec.physical.impl.window.WindowDataBatch;
import org.apache.drill.exec.physical.impl.window.WindowFramer;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NoFrameSupportTemplate
implements WindowFramer {
    private static final Logger logger = LoggerFactory.getLogger(NoFrameSupportTemplate.class);
    private VectorContainer container;
    private VectorContainer internal;
    private boolean lagCopiedToInternal;
    private List<WindowDataBatch> batches;
    private int outputCount;
    private WindowDataBatch current;
    private boolean requireFullPartition;
    private Partition partition;

    @Override
    public void setup(List<WindowDataBatch> batches, VectorContainer container, OperatorContext oContext, boolean requireFullPartition, WindowPOP popConfig) throws SchemaChangeException {
        this.container = container;
        this.batches = batches;
        this.internal = new VectorContainer(oContext);
        this.allocateInternal();
        this.lagCopiedToInternal = false;
        this.outputCount = 0;
        this.partition = null;
        this.requireFullPartition = requireFullPartition;
    }

    private void allocateInternal() {
        for (VectorWrapper<?> w : this.container) {
            Object vv = this.internal.addOrGet(w.getField());
            vv.allocateNew();
        }
    }

    @Override
    public void doWork() {
        int currentRow = 0;
        this.current = this.batches.get(0);
        this.outputCount = this.current.getRecordCount();
        while (currentRow < this.outputCount) {
            if (this.partition != null) {
                assert (currentRow == 0) : "pending windows are only expected at the start of the batch";
                logger.trace("we have a pending partition {}", (Object)this.partition);
                if (!this.requireFullPartition) {
                    this.updatePartitionSize(this.partition, currentRow);
                }
            } else {
                this.newPartition(this.current, currentRow);
            }
            try {
                currentRow = this.processPartition(currentRow);
            }
            catch (SchemaChangeException e) {
                throw AbstractRecordBatch.schemaChangeException(e, "Window", logger);
            }
            if (!this.partition.isDone()) continue;
            this.cleanPartition();
        }
    }

    private void newPartition(WindowDataBatch current, int currentRow) {
        this.partition = new Partition();
        this.updatePartitionSize(this.partition, currentRow);
        try {
            this.setupPartition(current, this.container);
        }
        catch (SchemaChangeException e) {
            throw AbstractRecordBatch.schemaChangeException(e, "Window", logger);
        }
    }

    private void cleanPartition() {
        this.partition = null;
        try {
            this.resetValues();
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        for (VectorWrapper<?> vw : this.internal) {
            if (!(vw.getValueVector() instanceof BaseDataValueVector)) continue;
            ((BaseDataValueVector)vw.getValueVector()).reset();
        }
        this.lagCopiedToInternal = false;
    }

    private int processPartition(int currentRow) throws SchemaChangeException {
        int row;
        logger.trace("process partition {}, currentRow: {}, outputCount: {}", new Object[]{this.partition, currentRow, this.outputCount});
        this.setupCopyNext(this.current, this.container);
        this.copyPrevFromInternal();
        this.setupCopyPrev(this.current, this.container);
        for (row = currentRow; row < this.outputCount && !this.partition.isDone(); ++row) {
            if (row != currentRow) {
                this.copyPrev(row - 1, row);
            }
            this.processRow(row);
            if (row >= this.outputCount - 1 || this.partition.isDone()) continue;
            this.copyNext(row + 1, row);
        }
        if (!this.partition.isDone() && this.batches.size() > 1) {
            this.setupCopyNext(this.batches.get(1), this.container);
            this.copyNext(0, row - 1);
            this.copyPrevToInternal(this.current, row);
        }
        return row;
    }

    private void copyPrevToInternal(VectorAccessible current, int row) {
        logger.trace("copying {} into internal", (Object)(row - 1));
        try {
            this.setupCopyPrev(current, this.internal);
            this.copyPrev(row - 1, 0);
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        this.lagCopiedToInternal = true;
    }

    private void copyPrevFromInternal() {
        if (this.lagCopiedToInternal) {
            try {
                this.setupCopyFromInternal(this.internal, this.container);
                this.copyFromInternal(0, 0);
            }
            catch (SchemaChangeException e) {
                throw new UnsupportedOperationException(e);
            }
            this.lagCopiedToInternal = false;
        }
    }

    private void processRow(int row) throws SchemaChangeException {
        if (this.partition.isFrameDone()) {
            long peers = this.countPeers(row);
            this.partition.newFrame(peers);
        }
        this.outputRow(row, this.partition);
        this.partition.rowAggregated();
    }

    private void updatePartitionSize(Partition partition, int start) {
        logger.trace("compute partition size starting from {} on {} batches", (Object)start, (Object)this.batches.size());
        long length = 0L;
        boolean lastBatch = false;
        int row = start;
        block4: for (WindowDataBatch batch : this.batches) {
            int recordCount = batch.getRecordCount();
            while (row < recordCount) {
                try {
                    if (!this.isSamePartition(start, this.current, row, batch)) {
                        break block4;
                    }
                }
                catch (SchemaChangeException e) {
                    throw new UnsupportedOperationException(e);
                }
                ++row;
                ++length;
            }
            if (!this.requireFullPartition) break;
            row = 0;
        }
        try {
            if (!this.requireFullPartition) {
                lastBatch = row < this.outputCount || this.batches.size() == 1 || !this.isSamePartition(start, this.current, 0, this.batches.get(1));
            }
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        partition.updateLength(length, !this.requireFullPartition && !lastBatch);
    }

    private long countPeers(int start) throws SchemaChangeException {
        long length = 0L;
        for (WindowDataBatch batch : this.batches) {
            int row;
            int recordCount = batch.getRecordCount();
            int n = row = batch == this.current ? start : 0;
            while (row < recordCount && this.isPeer(start, this.current, row, batch)) {
                ++row;
                ++length;
            }
        }
        return length;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public void cleanup() {
        logger.trace("clearing internal");
        this.internal.clear();
    }

    public String toString() {
        return "FrameSupportTemplate[internal=" + this.internal + ", outputCount=" + this.outputCount + ", current=" + this.current + ", requireFullPartition=" + this.requireFullPartition + ", partition=" + this.partition + "]";
    }

    public abstract void outputRow(@Named(value="outIndex") int var1, @Named(value="partition") Partition var2) throws SchemaChangeException;

    public abstract void setupPartition(@Named(value="incoming") WindowDataBatch var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void copyNext(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public abstract void setupCopyNext(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void copyPrev(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public abstract void setupCopyPrev(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract void copyFromInternal(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;

    public abstract void setupCopyFromInternal(@Named(value="incoming") VectorAccessible var1, @Named(value="outgoing") VectorAccessible var2) throws SchemaChangeException;

    public abstract boolean resetValues() throws SchemaChangeException;

    @Override
    public abstract boolean isSamePartition(@Named(value="b1Index") int var1, @Named(value="b1") VectorAccessible var2, @Named(value="b2Index") int var3, @Named(value="b2") VectorAccessible var4) throws SchemaChangeException;

    @Override
    public abstract boolean isPeer(@Named(value="b1Index") int var1, @Named(value="b1") VectorAccessible var2, @Named(value="b2Index") int var3, @Named(value="b2") VectorAccessible var4) throws SchemaChangeException;
}

