/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.values;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.physical.config.Values;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.scan.framework.BasicScanFactory;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedScanFramework;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.easy.json.JsonStreamBatchReader;

public class ValuesBatchCreator
implements BatchCreator<Values> {
    @Override
    public CloseableRecordBatch getBatch(ExecutorFragmentContext context, Values subScan, List<RecordBatch> children) throws ExecutionSetupException {
        assert (children.isEmpty());
        try {
            ManagedScanFramework.ScanFrameworkBuilder builder = this.createBuilder(subScan);
            return builder.buildScanOperator(context, subScan);
        }
        catch (UserException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ExecutionSetupException(e);
        }
    }

    private ManagedScanFramework.ScanFrameworkBuilder createBuilder(Values subScan) {
        ManagedScanFramework.ScanFrameworkBuilder builder = new ManagedScanFramework.ScanFrameworkBuilder();
        builder.setUserName(subScan.getUserName());
        builder.providedSchema(subScan.getSchema());
        BasicScanFactory readerFactory = new BasicScanFactory(Collections.singletonList(ValuesBatchCreator.getRecordReader(new ByteArrayInputStream(subScan.getContent().getBytes(StandardCharsets.UTF_8)))).iterator());
        builder.setReaderFactory(readerFactory);
        builder.nullType(Types.optional(TypeProtos.MinorType.VARCHAR));
        return builder;
    }

    private static ManagedReader<SchemaNegotiator> getRecordReader(InputStream source) {
        return new JsonStreamBatchReader(source);
    }
}

