/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unpivot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.UnpivotMaps;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpivotMapsRecordBatch
extends AbstractSingleRecordBatch<UnpivotMaps> {
    private static final Logger logger = LoggerFactory.getLogger(UnpivotMapsRecordBatch.class);
    private final List<String> mapFieldsNames;
    private boolean first = true;
    private int keyIndex;
    private List<String> keyList;
    private Map<MaterializedField, Map<String, ValueVector>> dataSrcVecMap;
    private Map<MaterializedField, ValueVector> copySrcVecMap;
    private List<TransferPair> transferList;
    private int recordCount;

    public UnpivotMapsRecordBatch(UnpivotMaps pop, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(pop, context, incoming);
        this.mapFieldsNames = pop.getMapFieldNames();
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome upStream = RecordBatch.IterOutcome.OK;
        if (this.keyIndex == 0) {
            upStream = this.next(this.incoming);
        }
        switch (upStream) {
            case NONE: 
            case NOT_YET: {
                return upStream;
            }
            case OK_NEW_SCHEMA: {
                this.first = false;
                this.setupNewSchema();
                return upStream;
            }
            case OK: {
                assert (!this.first) : "First batch should be OK_NEW_SCHEMA";
                this.container.zeroVectors();
                RecordBatch.IterOutcome out = this.doWork();
                if (out != RecordBatch.IterOutcome.OK) {
                    upStream = out;
                }
                return upStream;
            }
        }
        throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)upStream));
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    private void doTransfer() {
        int inputCount = this.incoming.getRecordCount();
        for (TransferPair tp : this.transferList) {
            tp.splitAndTransfer(0, inputCount);
        }
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        int outRecordCount = this.incoming.getRecordCount();
        this.prepareTransfers();
        this.doTransfer();
        this.keyIndex = (this.keyIndex + 1) % this.keyList.size();
        this.recordCount = outRecordCount;
        this.container.setRecordCount(this.recordCount);
        if (this.keyIndex == 0) {
            VectorAccessibleUtilities.clear(this.incoming.getContainer());
        }
        return RecordBatch.IterOutcome.OK;
    }

    private void buildKeyList() {
        List<String> lastMapKeyList = null;
        for (VectorWrapper vw : this.incoming) {
            if (vw.getField().getType().getMinorType() != TypeProtos.MinorType.MAP) continue;
            this.keyList = Lists.newArrayList();
            for (ValueVector vv : vw.getValueVector()) {
                this.keyList.add(SchemaPath.getSimplePath(vv.getField().getName()).toString());
            }
            if (lastMapKeyList == null) {
                lastMapKeyList = this.keyList;
                continue;
            }
            if (this.keyList.size() == lastMapKeyList.size() && lastMapKeyList.containsAll(this.keyList)) continue;
            throw new UnsupportedOperationException("Maps have different fields");
        }
    }

    private void buildOutputContainer() {
        this.dataSrcVecMap = Maps.newHashMap();
        this.copySrcVecMap = Maps.newHashMap();
        for (VectorWrapper vw : this.incoming) {
            MaterializedField ds = vw.getField();
            String colName = vw.getField().getName();
            if (!this.mapFieldsNames.contains(colName)) {
                TypeProtos.MajorType mt = vw.getValueVector().getField().getType();
                MaterializedField mf = MaterializedField.create(colName, mt);
                this.container.add(TypeHelper.getNewVector(mf, this.oContext.getAllocator()));
                this.copySrcVecMap.put(mf, (ValueVector)vw.getValueVector());
                continue;
            }
            MapVector mapVector = (MapVector)vw.getValueVector();
            assert (mapVector.getPrimitiveVectors().size() > 0);
            TypeProtos.MajorType mt = mapVector.iterator().next().getField().getType();
            MaterializedField mf = MaterializedField.create(colName, mt);
            assert (!this.dataSrcVecMap.containsKey(mf));
            this.container.add(TypeHelper.getNewVector(mf, this.oContext.getAllocator()));
            HashMap<String, ValueVector> m = Maps.newHashMap();
            this.dataSrcVecMap.put(mf, m);
            for (ValueVector vv : mapVector) {
                String fieldName = SchemaPath.getSimplePath(vv.getField().getName()).toString();
                if (!this.keyList.contains(fieldName)) {
                    throw new UnsupportedOperationException("Unpivot data vector " + ds + " contains key " + fieldName + " not contained in key source!");
                }
                if (vv.getField().getType().getMinorType() == TypeProtos.MinorType.MAP) {
                    throw new UnsupportedOperationException("Unpivot of nested map is not supported!");
                }
                m.put(fieldName, vv);
            }
        }
        this.container.buildSchema(this.incoming.getSchema().getSelectionVectorMode());
    }

    private void prepareTransfers() {
        this.transferList = Lists.newArrayList();
        for (VectorWrapper<?> vw : this.container) {
            TransferPair tp;
            ValueVector vv;
            MaterializedField mf = vw.getField();
            if (this.dataSrcVecMap.containsKey(mf)) {
                String k = this.keyList.get(this.keyIndex);
                vv = this.dataSrcVecMap.get(mf).get(k);
                tp = vv.makeTransferPair((ValueVector)vw.getValueVector());
            } else {
                vv = this.copySrcVecMap.get(mf);
                tp = vv.makeTransferPair((ValueVector)vw.getValueVector());
            }
            this.transferList.add(tp);
        }
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.clear();
        this.buildKeyList();
        this.buildOutputContainer();
        this.container.setEmpty();
        return true;
    }

    @Override
    public void dump() {
        logger.error("UnpivotMapsRecordbatch[recordCount={}, container={}]", (Object)this.recordCount, (Object)this.container);
    }
}

