/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unorderedreceiver;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.ExchangeFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.MinorFragmentEndpoint;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.CloseableRecordBatch;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.record.RawFragmentBatchProvider;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedReceiverBatch
implements CloseableRecordBatch {
    private static final Logger logger = LoggerFactory.getLogger(UnorderedReceiverBatch.class);
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(UnorderedReceiverBatch.class);
    private final RecordBatchLoader batchLoader;
    private final RawFragmentBatchProvider fragProvider;
    private final ExchangeFragmentContext context;
    private BatchSchema schema;
    private final OperatorStats stats;
    private boolean first = true;
    private final UnorderedReceiver config;
    private final OperatorContext oContext;
    private RecordBatch.IterOutcome lastOutcome;

    public UnorderedReceiverBatch(ExchangeFragmentContext context, RawFragmentBatchProvider fragProvider, UnorderedReceiver config) throws OutOfMemoryException {
        this.fragProvider = fragProvider;
        this.context = context;
        this.oContext = context.newOperatorContext(config);
        this.batchLoader = new RecordBatchLoader(this.oContext.getAllocator());
        this.stats = this.oContext.getStats();
        this.stats.setLongStat(Metric.NUM_SENDERS, config.getNumSenders());
        this.config = config;
        context.getBuffers().getCollector(config.getOppositeMajorFragmentId()).setAllocator(this.oContext.getAllocator());
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getRecordCount() {
        return this.batchLoader.getRecordCount();
    }

    @Override
    public void cancel() {
        this.informSenders();
        this.fragProvider.kill(this.context);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.batchLoader.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionVector4 getSelectionVector4() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.batchLoader.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.batchLoader.getValueAccessorById(clazz, ids);
    }

    private RawFragmentBatch getNextBatch() {
        try {
            injector.injectInterruptiblePause(this.context.getExecutionControls(), "waiting-for-data", logger);
            return this.fragProvider.getNext();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("Failure when reading incoming batch").build(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordBatch.IterOutcome next() {
        this.batchLoader.resetRecordCount();
        this.stats.startProcessing();
        try {
            RawFragmentBatch batch;
            try {
                this.stats.startWait();
                batch = this.getNextBatch();
                while (!(batch == null || batch.getHeader().getDef().getRecordCount() != 0 || this.first && batch.getHeader().getDef().getFieldCount() != 0)) {
                    batch = this.getNextBatch();
                }
            }
            finally {
                this.stats.stopWait();
            }
            this.first = false;
            if (batch == null) {
                this.lastOutcome = RecordBatch.IterOutcome.NONE;
                this.batchLoader.zero();
                this.context.getExecutorState().checkContinue();
                RecordBatch.IterOutcome iterOutcome = this.lastOutcome;
                return iterOutcome;
            }
            if (this.context.getAllocator().isOverLimit()) {
                this.context.requestMemory(this);
                if (this.context.getAllocator().isOverLimit()) {
                    throw new OutOfMemoryException("Allocator over limit");
                }
            }
            UserBitShared.RecordBatchDef rbd = batch.getHeader().getDef();
            boolean schemaChanged = this.batchLoader.load(rbd, batch.getBody());
            this.stats.addLongStat(Metric.BYTES_RECEIVED, batch.getByteCount());
            batch.release();
            if (schemaChanged) {
                this.schema = this.batchLoader.getSchema();
                this.stats.batchReceived(0, rbd.getRecordCount(), true);
                this.lastOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            } else {
                this.stats.batchReceived(0, rbd.getRecordCount(), false);
                this.lastOutcome = RecordBatch.IterOutcome.OK;
            }
            RecordBatch.IterOutcome iterOutcome = this.lastOutcome;
            return iterOutcome;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    @Override
    public WritableBatch getWritableBatch() {
        return this.batchLoader.getWritableBatch();
    }

    @Override
    public void close() {
        logger.debug("Closing {}", (Object)this.getClass().getCanonicalName());
        this.batchLoader.clear();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        throw new UnsupportedOperationException(String.format("You should not call getOutgoingContainer() for class %s", this.getClass().getCanonicalName()));
    }

    @Override
    public VectorContainer getContainer() {
        return this.batchLoader.getContainer();
    }

    private void informSenders() {
        logger.info("Informing senders of request to terminate sending.");
        ExecProtos.FragmentHandle handlePrototype = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(this.config.getOppositeMajorFragmentId()).setQueryId(this.context.getHandle().getQueryId()).build();
        for (MinorFragmentEndpoint providingEndpoint : this.config.getProvidingEndpoints()) {
            ExecProtos.FragmentHandle sender = ExecProtos.FragmentHandle.newBuilder(handlePrototype).setMinorFragmentId(providingEndpoint.getId()).build();
            BitControl.FinishedReceiver finishedReceiver = BitControl.FinishedReceiver.newBuilder().setReceiver(this.context.getHandle()).setSender(sender).build();
            this.context.getController().getTunnel(providingEndpoint.getEndpoint()).informReceiverFinished(new OutcomeListener(), finishedReceiver);
        }
    }

    @Override
    public void dump() {
        logger.error("UnorderedReceiverBatch[batchLoader={}, schema={}]", (Object)this.batchLoader, (Object)this.schema);
    }

    public static enum Metric implements MetricDef
    {
        BYTES_RECEIVED,
        NUM_SENDERS;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }

    private class OutcomeListener
    implements RpcOutcomeListener<GeneralRPCProtos.Ack> {
        private OutcomeListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.warn("Failed to inform upstream that receiver is finished");
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.debug("{} interrupted. shouldContinue value: {}", (Object)this.getClass().getCanonicalName(), (Object)UnorderedReceiverBatch.this.context.getExecutorState().shouldContinue());
            if (UnorderedReceiverBatch.this.context.getExecutorState().shouldContinue()) {
                String errMsg = "Received an interrupt RPC outcome while sending ReceiverFinished message";
                logger.error(errMsg, (Throwable)e);
                UnorderedReceiverBatch.this.context.getExecutorState().fail(new RpcException(errMsg, e));
            }
        }
    }
}

