/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unnest;

import java.util.ArrayList;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.UnnestPOP;
import org.apache.drill.exec.physical.impl.unnest.Unnest;
import org.apache.drill.exec.physical.impl.unnest.UnnestImpl;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.AbstractTableFunctionRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchMemoryManager;
import org.apache.drill.exec.record.RecordBatchSizer;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnestRecordBatch
extends AbstractTableFunctionRecordBatch<UnnestPOP> {
    private static final Logger logger = LoggerFactory.getLogger(UnnestRecordBatch.class);
    private final String rowIdColumnName;
    private IntVector rowIdVector;
    private Unnest unnest = new UnnestImpl();
    private boolean hasRemainder;
    private int remainderIndex;
    private MaterializedField unnestFieldMetadata;
    private TypedFieldId unnestTypedFieldId;
    private final UnnestMemoryManager memoryManager;

    public UnnestRecordBatch(UnnestPOP pop, FragmentContext context) throws OutOfMemoryException {
        super(pop, context);
        pop.addUnnestBatch(this);
        int configuredBatchSize = (int)context.getOptions().getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR);
        RecordBatchStats.printConfiguredBatchSize(this.getRecordBatchStatsContext(), configuredBatchSize);
        this.memoryManager = new UnnestMemoryManager(configuredBatchSize);
        this.rowIdColumnName = pop.getImplicitColumn();
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }

    @Override
    protected void cancelIncoming() {
        Preconditions.checkNotNull(this.lateral);
        logger.debug("Cancel received. Stopping all processing");
        this.state = AbstractRecordBatch.BatchState.DONE;
        this.hasRemainder = false;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        Preconditions.checkNotNull(this.lateral);
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        if (this.hasRemainder) {
            return this.doWork();
        }
        if (this.state == AbstractRecordBatch.BatchState.FIRST) {
            this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
            try {
                this.stats.startSetup();
                logger.debug("First batch received");
                this.schemaChanged();
                this.setupNewSchema();
                this.stats.batchReceived(0, this.incoming.getRecordCount(), true);
                this.memoryManager.update();
                this.hasRemainder = this.incoming.getRecordCount() > 0;
            }
            finally {
                this.stats.stopSetup();
            }
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        Preconditions.checkState(this.incoming.getRecordCount() > 0, "Incoming batch post buildSchema phase should never be empty for Unnest");
        this.container.zeroVectors();
        if (this.lateral.getRecordIndex() == 0) {
            boolean hasNewSchema = this.schemaChanged();
            this.stats.batchReceived(0, this.incoming.getRecordCount(), hasNewSchema);
            if (hasNewSchema) {
                this.setupNewSchema();
                this.hasRemainder = true;
                this.memoryManager.update();
                return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            }
            this.resetUnnestTransferPair();
            this.container.zeroVectors();
            this.unnest.resetGroupIndex();
            this.memoryManager.update();
        }
        return this.doWork();
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    private void setUnnestVector() {
        RepeatedValueVector vector;
        MaterializedField field = this.incoming.getSchema().getColumn(this.unnestTypedFieldId.getFieldIds()[0]);
        Object inVV = this.incoming.getValueAccessorById(field.getValueClass(), this.unnestTypedFieldId.getFieldIds()).getValueVector();
        if (!(inVV instanceof RepeatedValueVector)) {
            if (this.incoming.getRecordCount() != 0) {
                throw UserException.unsupportedError().message("Unnest does not support inputs of non-list values.", new Object[0]).build(logger);
            }
            logger.error("setUnnestVector cast failed and recordcount is 0, create empty vector anyway.");
            vector = new RepeatedMapVector(field, this.oContext.getAllocator(), null);
        } else {
            vector = (RepeatedValueVector)RepeatedValueVector.class.cast(inVV);
        }
        this.unnest.setUnnestField(vector);
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        Preconditions.checkNotNull(this.lateral);
        this.unnest.setOutputCount(this.memoryManager.getOutputRowCount());
        int incomingRecordCount = this.incoming.getRecordCount();
        int remainingRecordCount = this.unnest.getUnnestField().getAccessor().getInnerValueCount() - this.remainderIndex;
        this.rowIdVector.allocateNew(Math.min(remainingRecordCount, this.memoryManager.getOutputRowCount()));
        int childCount = incomingRecordCount == 0 ? 0 : remainingRecordCount;
        int outputRecords = childCount == 0 ? 0 : this.unnest.unnestRecords(childCount);
        logger.debug("{} values out of {} were processed.", (Object)outputRecords, (Object)childCount);
        if (outputRecords < childCount) {
            this.hasRemainder = true;
            this.remainderIndex += outputRecords;
            logger.debug("Output spilled into new batch. IterOutcome: OK.");
        } else {
            this.hasRemainder = false;
            this.remainderIndex = 0;
            logger.debug("IterOutcome: EMIT.");
        }
        this.rowIdVector.getMutator().setValueCount(outputRecords);
        this.container.setValueCount(outputRecords);
        this.memoryManager.updateOutgoingStats(outputRecords);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
        return this.hasRemainder ? RecordBatch.IterOutcome.OK : RecordBatch.IterOutcome.EMIT;
    }

    private TransferPair getUnnestFieldTransferPair(FieldReference reference) {
        int[] typeFieldIds = this.unnestTypedFieldId.getFieldIds();
        Class<?> vectorClass = this.incoming.getSchema().getColumn(typeFieldIds[0]).getValueClass();
        Object unnestField = this.incoming.getValueAccessorById(vectorClass, typeFieldIds).getValueVector();
        TransferPair tp = null;
        if (unnestField instanceof RepeatedMapVector) {
            tp = ((RepeatedMapVector)unnestField).getTransferPairToSingleMap(reference.getAsNamePart().getName(), this.oContext.getAllocator());
        } else if (!(unnestField instanceof RepeatedValueVector)) {
            if (this.incoming.getRecordCount() != 0) {
                throw UserException.unsupportedError().message("Unnest does not support inputs of non-list values.", new Object[0]).build(logger);
            }
            logger.error("Cannot cast {} to RepeatedValueVector", unnestField);
            RepeatedMapVector vv = new RepeatedMapVector(unnestField.getField(), this.oContext.getAllocator(), null);
            tp = ((RepeatedValueVector)RepeatedValueVector.class.cast(vv)).getTransferPair(reference.getAsNamePart().getName(), this.oContext.getAllocator());
        } else {
            ValueVector vvIn = ((RepeatedValueVector)RepeatedValueVector.class.cast(unnestField)).getDataVector();
            if (vvIn != null) {
                tp = vvIn.getTransferPair(reference.getAsNamePart().getName(), this.oContext.getAllocator());
            }
        }
        return tp;
    }

    private TransferPair resetUnnestTransferPair() {
        ArrayList<TransferPair> transfers = Lists.newArrayList();
        FieldReference fieldReference = new FieldReference(((UnnestPOP)this.popConfig).getColumn());
        TransferPair transferPair = this.getUnnestFieldTransferPair(fieldReference);
        transfers.add(transferPair);
        logger.debug("Added transfer for unnest expression.");
        this.unnest.close();
        try {
            this.unnest.setup(this.context, this.incoming, this, transfers);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
        this.setUnnestVector();
        return transferPair;
    }

    @Override
    protected boolean setupNewSchema() {
        Preconditions.checkNotNull(this.lateral);
        this.container.clear();
        MaterializedField rowIdField = MaterializedField.create(this.rowIdColumnName, Types.required(TypeProtos.MinorType.INT));
        this.rowIdVector = (IntVector)TypeHelper.getNewVector(rowIdField, this.oContext.getAllocator());
        this.container.add(this.rowIdVector);
        this.unnest = new UnnestImpl();
        this.unnest.setRowIdVector(this.rowIdVector);
        TransferPair tp = this.resetUnnestTransferPair();
        this.container.add(TypeHelper.getNewVector(tp.getTo().getField(), this.oContext.getAllocator()));
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setEmpty();
        return true;
    }

    private boolean schemaChanged() {
        this.unnestTypedFieldId = this.checkAndGetUnnestFieldId();
        MaterializedField thisField = this.incoming.getSchema().getColumn(this.unnestTypedFieldId.getFieldIds()[0]);
        MaterializedField prevField = this.unnestFieldMetadata;
        Preconditions.checkNotNull(thisField);
        if (prevField == null || !prevField.isEquivalent(thisField)) {
            this.unnestFieldMetadata = thisField.clone();
            return true;
        }
        return false;
    }

    private void updateStats() {
        if (this.memoryManager.getRecordBatchSizer() == null) {
            return;
        }
        this.stats.setLongStat(Metric.INPUT_BATCH_COUNT, this.memoryManager.getNumIncomingBatches());
        this.stats.setLongStat(Metric.AVG_INPUT_BATCH_BYTES, this.memoryManager.getAvgInputBatchSize());
        this.stats.setLongStat(Metric.AVG_INPUT_ROW_BYTES, this.memoryManager.getAvgInputRowWidth());
        this.stats.setLongStat(Metric.INPUT_RECORD_COUNT, this.memoryManager.getTotalInputRecords());
        this.stats.setLongStat(Metric.OUTPUT_BATCH_COUNT, this.memoryManager.getNumOutgoingBatches());
        this.stats.setLongStat(Metric.AVG_OUTPUT_BATCH_BYTES, this.memoryManager.getAvgOutputBatchSize());
        this.stats.setLongStat(Metric.AVG_OUTPUT_ROW_BYTES, this.memoryManager.getAvgOutputRowWidth());
        this.stats.setLongStat(Metric.OUTPUT_RECORD_COUNT, this.memoryManager.getTotalOutputRecords());
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate: batch count : %d, avg batch bytes : %d,  avg row bytes : %d, record count : %d", this.memoryManager.getNumIncomingBatches(), this.memoryManager.getAvgInputBatchSize(), this.memoryManager.getAvgInputRowWidth(), this.memoryManager.getTotalInputRecords());
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "outgoing aggregate: batch count : %d, avg batch bytes : %d,  avg row bytes : %d, record count : %d", this.memoryManager.getNumOutgoingBatches(), this.memoryManager.getAvgOutputBatchSize(), this.memoryManager.getAvgOutputRowWidth(), this.memoryManager.getTotalOutputRecords());
    }

    private TypedFieldId checkAndGetUnnestFieldId() {
        TypedFieldId fieldId = this.incoming.getValueVectorId(((UnnestPOP)this.popConfig).getColumn());
        if (fieldId == null) {
            throw UserException.schemaChangeError(null).message(String.format("Unnest column %s not found inside the incoming record batch. This may happen if a wrong Unnest column name is used in the query. Please rerun query after fixing that.", ((UnnestPOP)this.popConfig).getColumn()), new Object[0]).build(logger);
        }
        return fieldId;
    }

    @Override
    public void close() {
        this.updateStats();
        this.unnest.close();
        super.close();
    }

    @Override
    public void dump() {
        logger.error("UnnestRecordBatch[container={}, unnest={}, hasRemainder={}, remainderIndex={}, unnestFieldMetadata={}]", new Object[]{this.container, this.unnest, this.hasRemainder, this.remainderIndex, this.unnestFieldMetadata});
    }

    private class UnnestMemoryManager
    extends RecordBatchMemoryManager {
        private UnnestMemoryManager(int outputBatchSize) {
            super(outputBatchSize);
        }

        @Override
        public void update() {
            this.setRecordBatchSizer(new RecordBatchSizer(UnnestRecordBatch.this.incoming));
            RecordBatchSizer.ColumnSize columnSize = this.getRecordBatchSizer().getColumn(UnnestRecordBatch.this.unnestFieldMetadata.getName());
            int rowIdColumnSize = TypeHelper.getSize(UnnestRecordBatch.this.rowIdVector.getField().getType());
            int avgRowWidthSingleUnnestEntry = RecordBatchSizer.safeDivide(columnSize.getTotalNetSize() - this.getOffsetVectorWidth() * columnSize.getValueCount(), columnSize.getElementCount());
            int avgOutgoingRowWidth = avgRowWidthSingleUnnestEntry + rowIdColumnSize;
            int outputBatchSize = this.getOutputBatchSize();
            this.setOutputRowCount(outputBatchSize, avgOutgoingRowWidth);
            this.setOutgoingRowWidth(avgOutgoingRowWidth);
            this.setOutputRowCount(Math.min(columnSize.getElementCount(), this.getOutputRowCount()));
            RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.INPUT, this.getRecordBatchSizer(), UnnestRecordBatch.this.getRecordBatchStatsContext());
            this.updateIncomingStats();
        }
    }

    public static enum Metric implements MetricDef
    {
        INPUT_BATCH_COUNT,
        AVG_INPUT_BATCH_BYTES,
        AVG_INPUT_ROW_BYTES,
        INPUT_RECORD_COUNT,
        OUTPUT_BATCH_COUNT,
        AVG_OUTPUT_BATCH_BYTES,
        AVG_OUTPUT_ROW_BYTES,
        OUTPUT_RECORD_COUNT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

