/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.union;

import java.util.List;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.union.UnionAller;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public abstract class UnionAllerTemplate
implements UnionAller {
    private ImmutableList<TransferPair> transfers;

    @Override
    public final int unionRecords(int startIndex, int recordCount, int firstOutputIndex) {
        try {
            int i = startIndex;
            while (i < startIndex + recordCount) {
                this.doEval(i, firstOutputIndex);
                ++i;
                ++firstOutputIndex;
            }
        }
        catch (SchemaChangeException e) {
            throw new UnsupportedOperationException(e);
        }
        for (TransferPair t : this.transfers) {
            t.splitAndTransfer(startIndex, recordCount);
        }
        return recordCount;
    }

    @Override
    public final void setup(FragmentContext context, RecordBatch incoming, RecordBatch outgoing, List<TransferPair> transfers) throws SchemaChangeException {
        this.transfers = ImmutableList.copyOf(transfers);
        this.doSetup(context, incoming, outgoing);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") RecordBatch var2, @Named(value="outgoing") RecordBatch var3) throws SchemaChangeException;

    public abstract void doEval(@Named(value="inIndex") int var1, @Named(value="outIndex") int var2) throws SchemaChangeException;
}

