/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.union;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.UnionAll;
import org.apache.drill.exec.physical.impl.union.UnionAller;
import org.apache.drill.exec.record.AbstractBinaryRecordBatch;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchMemoryManager;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessibleUtilities;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.util.VectorUtil;
import org.apache.drill.exec.util.record.RecordBatchStats;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionAllRecordBatch
extends AbstractBinaryRecordBatch<UnionAll> {
    private static final Logger logger = LoggerFactory.getLogger(UnionAllRecordBatch.class);
    private final SchemaChangeCallBack callBack = new SchemaChangeCallBack();
    private UnionAller unionall;
    private final List<TransferPair> transfers = new ArrayList<TransferPair>();
    private final List<ValueVector> allocationVectors = new ArrayList<ValueVector>();
    private int recordCount;
    private Iterator<Pair<RecordBatch.IterOutcome, BatchStatusWrappper>> unionInputIterator;

    public UnionAllRecordBatch(UnionAll config, List<RecordBatch> children, FragmentContext context) throws OutOfMemoryException {
        super(config, context, true, children.get(0), children.get(1));
        int configuredBatchSize = (int)context.getOptions().getOption(ExecConstants.OUTPUT_BATCH_SIZE_VALIDATOR);
        this.batchMemoryManager = new RecordBatchMemoryManager(2, configuredBatchSize);
        RecordBatchStats.printConfiguredBatchSize(this.getRecordBatchStatsContext(), configuredBatchSize);
    }

    @Override
    protected void buildSchema() {
        if (!this.prefetchFirstBatchFromBothSides()) {
            this.state = AbstractRecordBatch.BatchState.DONE;
            return;
        }
        this.unionInputIterator = new UnionInputIterator(this.leftUpstream, this.left, this.rightUpstream, this.right);
        if (this.leftUpstream == RecordBatch.IterOutcome.NONE && this.rightUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            this.inferOutputFieldsOneSide(this.right.getSchema());
        } else if (this.rightUpstream == RecordBatch.IterOutcome.NONE && this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            this.inferOutputFieldsOneSide(this.left.getSchema());
        } else if (this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA && this.rightUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            this.inferOutputFieldsBothSide(this.left.getSchema(), this.right.getSchema());
        }
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        VectorAccessibleUtilities.allocateVectors(this.container, 0);
        VectorAccessibleUtilities.setValueCount(this.container, 0);
        this.container.setRecordCount(0);
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome upstream;
        block5: while (true) {
            if (!this.unionInputIterator.hasNext()) {
                return RecordBatch.IterOutcome.NONE;
            }
            Pair<RecordBatch.IterOutcome, BatchStatusWrappper> nextBatch = this.unionInputIterator.next();
            upstream = (RecordBatch.IterOutcome)((Object)nextBatch.left);
            BatchStatusWrappper batchStatus = (BatchStatusWrappper)nextBatch.right;
            switch (upstream) {
                case NONE: {
                    return upstream;
                }
                case OK_NEW_SCHEMA: {
                    return this.doWork(batchStatus, true);
                }
                case OK: {
                    if (batchStatus.batch.getRecordCount() == 0) {
                        VectorAccessibleUtilities.clear(batchStatus.batch);
                        continue block5;
                    }
                    return this.doWork(batchStatus, false);
                }
            }
            break;
        }
        throw new IllegalStateException(String.format("Unknown state %s.", new Object[]{upstream}));
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    private RecordBatch.IterOutcome doWork(BatchStatusWrappper batchStatus, boolean newSchema) {
        Preconditions.checkArgument(batchStatus.batch.getSchema().getFieldCount() == this.container.getSchema().getFieldCount(), "Input batch and output batch have different field counthas!");
        if (newSchema) {
            this.createUnionAller(batchStatus.batch);
        }
        int recordsToProcess = Math.min(this.batchMemoryManager.getOutputRowCount(), batchStatus.getRemainingRecords());
        this.container.zeroVectors();
        this.batchMemoryManager.allocateVectors(this.allocationVectors, recordsToProcess);
        this.recordCount = this.unionall.unionRecords(batchStatus.recordsProcessed, recordsToProcess, 0);
        VectorUtil.setValueCount(this.allocationVectors, this.recordCount);
        this.container.setRecordCount(this.recordCount);
        batchStatus.recordsProcessed += this.recordCount;
        this.batchMemoryManager.updateOutgoingStats(this.recordCount);
        RecordBatchStats.logRecordBatchStats(RecordBatchStats.RecordBatchIOType.OUTPUT, this, this.getRecordBatchStatsContext());
        if (this.callBack.getSchemaChangedAndReset()) {
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        return RecordBatch.IterOutcome.OK;
    }

    private void createUnionAller(RecordBatch inputBatch) {
        this.transfers.clear();
        this.allocationVectors.clear();
        ClassGenerator<UnionAller> cg = CodeGenerator.getRoot(UnionAller.TEMPLATE_DEFINITION, this.context.getOptions());
        cg.getCodeGenerator().plainJavaCapable(true);
        int index = 0;
        for (VectorWrapper vw : inputBatch) {
            Object vvIn = vw.getValueVector();
            Object vvOut = this.container.getValueVector(index).getValueVector();
            MaterializedField inField = vvIn.getField();
            MaterializedField outputField = vvOut.getField();
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            if (this.areAssignableTypes(inField.getType(), outputField.getType())) {
                TransferPair tp = vvIn.makeTransferPair((ValueVector)vvOut);
                this.transfers.add(tp);
            } else {
                if (inField.getType().getMinorType() == TypeProtos.MinorType.NULL) {
                    ++index;
                    continue;
                }
                SchemaPath inputPath = SchemaPath.getSimplePath(inField.getName());
                LogicalExpression expr = ExpressionTreeMaterializer.materialize(inputPath, inputBatch, collector, this.context.getFunctionRegistry());
                collector.reportErrors(logger);
                if (inField.getType().getMode() == TypeProtos.DataMode.REQUIRED && outputField.getType().getMode() != TypeProtos.DataMode.REQUIRED) {
                    expr = ExpressionTreeMaterializer.convertToNullableType(expr, inField.getType().getMinorType(), this.context.getFunctionRegistry(), collector);
                    collector.reportErrors(logger);
                }
                if (this.isCastRequired(inField.getType(), outputField.getType())) {
                    expr = ExpressionTreeMaterializer.addCastExpression(expr, outputField.getType(), this.context.getFunctionRegistry(), collector);
                    collector.reportErrors(logger);
                }
                TypedFieldId fid = this.container.getValueVectorId(SchemaPath.getSimplePath(outputField.getName()));
                boolean useSetSafe = !(vvOut instanceof FixedWidthVector);
                ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, useSetSafe);
                cg.addExpr(write);
                this.allocationVectors.add((ValueVector)vvOut);
            }
            ++index;
        }
        this.unionall = this.context.getImplementationClass(cg.getCodeGenerator());
        try {
            this.unionall.setup(this.context, inputBatch, this, this.transfers);
        }
        catch (SchemaChangeException e) {
            throw this.schemaChangeException(e, logger);
        }
    }

    private boolean isCastRequired(TypeProtos.MajorType first, TypeProtos.MajorType second) {
        return first.getMinorType() != second.getMinorType() || Types.areDecimalTypes(second.getMinorType(), first.getMinorType()) && second.getScale() != first.getScale();
    }

    private boolean areAssignableTypes(TypeProtos.MajorType first, TypeProtos.MajorType second) {
        boolean areDecimalTypes = Types.areDecimalTypes(first.getMinorType(), second.getMinorType());
        return Types.isSameTypeAndMode(first, second) && second.getMinorType() != TypeProtos.MinorType.MAP && (!areDecimalTypes || first.getScale() == second.getScale());
    }

    private void inferOutputFieldsBothSide(BatchSchema leftSchema, BatchSchema rightSchema) {
        Iterator<MaterializedField> leftIter = leftSchema.iterator();
        Iterator<MaterializedField> rightIter = rightSchema.iterator();
        int index = 1;
        while (leftIter.hasNext() && rightIter.hasNext()) {
            TypeProtos.MajorType.Builder builder;
            MaterializedField leftField = leftIter.next();
            MaterializedField rightField = rightIter.next();
            if (Types.isSameTypeAndMode(leftField.getType(), rightField.getType())) {
                builder = TypeProtos.MajorType.newBuilder().setMinorType(leftField.getType().getMinorType()).setMode(leftField.getDataMode());
                builder = Types.calculateTypePrecisionAndScale(leftField.getType(), rightField.getType(), builder);
                this.container.addOrGet(MaterializedField.create(leftField.getName(), builder.build()), this.callBack);
            } else if (Types.isUntypedNull(rightField.getType())) {
                this.container.addOrGet(leftField, this.callBack);
            } else if (Types.isUntypedNull(leftField.getType())) {
                this.container.addOrGet(MaterializedField.create(leftField.getName(), rightField.getType()), this.callBack);
            } else {
                builder = TypeProtos.MajorType.newBuilder();
                if (leftField.getType().getMinorType() == rightField.getType().getMinorType()) {
                    builder.setMinorType(leftField.getType().getMinorType());
                    builder = Types.calculateTypePrecisionAndScale(leftField.getType(), rightField.getType(), builder);
                } else {
                    TypeProtos.MinorType outputMinorType = TypeCastRules.getLeastRestrictiveType(leftField.getType().getMinorType(), rightField.getType().getMinorType());
                    if (outputMinorType == null) {
                        throw new DrillRuntimeException("Type mismatch between " + leftField.getType().getMinorType().toString() + " on the left side and " + rightField.getType().getMinorType().toString() + " on the right side in column " + index + " of UNION ALL");
                    }
                    builder.setMinorType(outputMinorType);
                }
                builder.setMode(TypeCastRules.getLeastRestrictiveDataMode(leftField.getType().getMode(), rightField.getType().getMode()));
                this.container.addOrGet(MaterializedField.create(leftField.getName(), builder.build()), this.callBack);
            }
            ++index;
        }
        assert (!leftIter.hasNext() && !rightIter.hasNext()) : "Mismatch of column count should have been detected when validating sqlNode at planning";
    }

    private void inferOutputFieldsOneSide(BatchSchema schema) {
        for (MaterializedField field : schema) {
            this.container.addOrGet(field, this.callBack);
        }
    }

    @Override
    protected void cancelIncoming() {
        super.cancelIncoming();
        this.unionInputIterator = Collections.emptyIterator();
    }

    @Override
    public void close() {
        super.close();
        this.updateBatchMemoryManagerStats();
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate left: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumIncomingBatches(0), this.batchMemoryManager.getAvgInputBatchSize(0), this.batchMemoryManager.getAvgInputRowWidth(0), this.batchMemoryManager.getTotalInputRecords(0));
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "incoming aggregate right: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumIncomingBatches(1), this.batchMemoryManager.getAvgInputBatchSize(1), this.batchMemoryManager.getAvgInputRowWidth(1), this.batchMemoryManager.getTotalInputRecords(1));
        RecordBatchStats.logRecordBatchStats(this.getRecordBatchStatsContext(), "outgoing aggregate: batch count : %d, avg bytes : %d,  avg row bytes : %d, record count : %d", this.batchMemoryManager.getNumOutgoingBatches(), this.batchMemoryManager.getAvgOutputBatchSize(), this.batchMemoryManager.getAvgOutputRowWidth(), this.batchMemoryManager.getTotalOutputRecords());
    }

    @Override
    public void dump() {
        logger.error("UnionAllRecordBatch[container={}, left={}, right={}, leftOutcome={}, rightOutcome={}, recordCount={}]", new Object[]{this.container, this.left, this.right, this.leftUpstream, this.rightUpstream, this.recordCount});
    }

    private class UnionInputIterator
    implements Iterator<Pair<RecordBatch.IterOutcome, BatchStatusWrappper>> {
        private final Stack<BatchStatusWrappper> batchStatusStack = new Stack();

        UnionInputIterator(RecordBatch.IterOutcome leftOutCome, RecordBatch left, RecordBatch.IterOutcome rightOutCome, RecordBatch right) {
            if (rightOutCome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                this.batchStatusStack.push(new BatchStatusWrappper(true, RecordBatch.IterOutcome.OK_NEW_SCHEMA, right, 1));
            }
            if (leftOutCome == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                this.batchStatusStack.push(new BatchStatusWrappper(true, RecordBatch.IterOutcome.OK_NEW_SCHEMA, left, 0));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.batchStatusStack.isEmpty();
        }

        @Override
        public Pair<RecordBatch.IterOutcome, BatchStatusWrappper> next() {
            block4: while (!this.batchStatusStack.isEmpty()) {
                BatchStatusWrappper topStatus = this.batchStatusStack.peek();
                if (topStatus.prefetched) {
                    topStatus.prefetched = false;
                    UnionAllRecordBatch.this.batchMemoryManager.update(topStatus.batch, topStatus.inputIndex);
                    RecordBatchStats.logRecordBatchStats(topStatus.inputIndex == 0 ? RecordBatchStats.RecordBatchIOType.INPUT_LEFT : RecordBatchStats.RecordBatchIOType.INPUT_RIGHT, UnionAllRecordBatch.this.batchMemoryManager.getRecordBatchSizer(topStatus.inputIndex), UnionAllRecordBatch.this.getRecordBatchStatsContext());
                    return Pair.of((Object)((Object)topStatus.outcome), (Object)topStatus);
                }
                if (topStatus.getRemainingRecords() > 0) {
                    return Pair.of((Object)((Object)RecordBatch.IterOutcome.OK), (Object)topStatus);
                }
                RecordBatch.IterOutcome outcome = UnionAllRecordBatch.this.next(topStatus.inputIndex, topStatus.batch);
                switch (outcome) {
                    case OK_NEW_SCHEMA: 
                    case OK: {
                        topStatus.recordsProcessed = 0;
                        topStatus.totalRecordsToProcess = topStatus.batch.getRecordCount();
                        UnionAllRecordBatch.this.batchMemoryManager.update(topStatus.batch, topStatus.inputIndex);
                        RecordBatchStats.logRecordBatchStats(topStatus.inputIndex == 0 ? RecordBatchStats.RecordBatchIOType.INPUT_LEFT : RecordBatchStats.RecordBatchIOType.INPUT_RIGHT, UnionAllRecordBatch.this.batchMemoryManager.getRecordBatchSizer(topStatus.inputIndex), UnionAllRecordBatch.this.getRecordBatchStatsContext());
                        return Pair.of((Object)((Object)outcome), (Object)topStatus);
                    }
                    case NONE: {
                        this.batchStatusStack.pop();
                        if (!this.batchStatusStack.isEmpty()) continue block4;
                        return Pair.of((Object)((Object)RecordBatch.IterOutcome.NONE), null);
                    }
                }
                throw new IllegalStateException(String.format("Unexpected state %s", new Object[]{outcome}));
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class BatchStatusWrappper {
        boolean prefetched;
        final RecordBatch batch;
        final int inputIndex;
        final RecordBatch.IterOutcome outcome;
        int recordsProcessed;
        int totalRecordsToProcess;

        BatchStatusWrappper(boolean prefetched, RecordBatch.IterOutcome outcome, RecordBatch batch, int inputIndex) {
            this.prefetched = prefetched;
            this.outcome = outcome;
            this.batch = batch;
            this.inputIndex = inputIndex;
            this.totalRecordsToProcess = batch.getRecordCount();
            this.recordsProcessed = 0;
        }

        public int getRemainingRecords() {
            return this.totalRecordsToProcess - this.recordsProcessed;
        }
    }
}

