/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.svremover;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.physical.impl.svremover.AbstractCopier;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.vector.ValueVector;

public abstract class AbstractSV2Copier
extends AbstractCopier {
    protected ValueVector[] vvIn;
    private SelectionVector2 sv2;
    protected List<TransferPair> transferPairs = new ArrayList<TransferPair>();

    @Override
    public void setup(VectorAccessible incoming, VectorContainer outgoing) {
        super.setup(incoming, outgoing);
        this.sv2 = incoming.getSelectionVector2();
        int count = outgoing.getNumberOfColumns();
        this.vvIn = new ValueVector[count];
        int index = 0;
        for (VectorWrapper vectorWrapper : incoming) {
            this.vvIn[index++] = vectorWrapper.getValueVector();
        }
    }

    @Override
    public void copyEntryIndirect(int inIndex, int outIndex) {
        this.copyEntry(this.sv2.getIndex(inIndex), outIndex);
    }

    @Override
    public int copyRecords(int index, int recordCount) {
        if (this.sv2.canDoFullTransfer()) {
            for (TransferPair pair : this.transferPairs) {
                pair.transfer();
            }
            this.updateCounts(recordCount);
            return recordCount;
        }
        return super.copyRecords(index, recordCount);
    }
}

