/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.physical.config.StatisticsMerge;
import org.apache.drill.exec.physical.impl.statistics.AvgWidthMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.CntDupsMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.HLLMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.MergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.MergedStatisticFactory;
import org.apache.drill.exec.physical.impl.statistics.NDVMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.TDigestMergedStatistic;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class StatisticsMergeBatch
extends AbstractSingleRecordBatch<StatisticsMerge> {
    private final Map<String, String> functions;
    private boolean first = true;
    private boolean finished;
    private int schema;
    private List<String> columnsList;
    private double samplePercent = 100.0;
    private final List<MergedStatistic> mergedStatisticList;

    public StatisticsMergeBatch(StatisticsMerge popConfig, RecordBatch incoming, FragmentContext context) throws OutOfMemoryException {
        super(popConfig, context, incoming);
        this.functions = popConfig.getFunctions();
        this.samplePercent = popConfig.getSamplePercent();
        this.mergedStatisticList = new ArrayList<MergedStatistic>();
    }

    private void createKeyColumn(String name, LogicalExpression expr) {
        LogicalExpression mle = PhysicalOperatorUtil.materializeExpression(expr, this.incoming, this.context);
        MaterializedField outputField = MaterializedField.create(name, mle.getMajorType());
        ValueVector vector = TypeHelper.getNewVector(outputField, this.oContext.getAllocator());
        this.container.add(vector);
    }

    private void buildColumnsList() {
        String inputFunc;
        HashMap<String, Boolean> inputFunctions = new HashMap<String, Boolean>();
        for (String inputFunc2 : this.functions.values()) {
            inputFunctions.put(inputFunc2, false);
        }
        List<String> lastMapColumnsList = null;
        for (VectorWrapper vw : this.incoming) {
            inputFunc = vw.getField().getName();
            if (vw.getField().getType().getMinorType() != TypeProtos.MinorType.MAP) continue;
            if (((Boolean)inputFunctions.get(inputFunc)).booleanValue()) {
                throw new IllegalArgumentException(String.format("The statistic `%s` appears more than once", inputFunc));
            }
            inputFunctions.put(inputFunc, true);
            if (!vw.getField().getName().equals("column")) continue;
            this.columnsList = Lists.newArrayList();
            for (ValueVector vv : vw.getValueVector()) {
                if (vv.getField().getType().getMinorType() == TypeProtos.MinorType.MAP) {
                    throw new IllegalArgumentException("StatisticsMerge of nested map is not supported");
                }
                this.columnsList.add(vv.getField().getName());
            }
            lastMapColumnsList = this.columnsList;
        }
        for (VectorWrapper vw : this.incoming) {
            inputFunc = vw.getField().getName();
            if (vw.getField().getType().getMinorType() != TypeProtos.MinorType.MAP) continue;
            if (!((Boolean)inputFunctions.get(inputFunc)).booleanValue()) {
                throw new IllegalArgumentException(String.format("The statistic `%s` is not expected here", inputFunc));
            }
            if (this.columnsList.size() == lastMapColumnsList.size() && lastMapColumnsList.containsAll(this.columnsList)) continue;
            throw new IllegalStateException("StatisticsMerge Maps have different fields");
        }
    }

    private void buildOutputContainer() {
        for (VectorWrapper vw : this.incoming) {
            for (String outputStatName : this.functions.keySet()) {
                if (!this.functions.get(outputStatName).equals(vw.getField().getName())) continue;
                this.mergedStatisticList.add(MergedStatisticFactory.getMergedStatistic(outputStatName, this.functions.get(outputStatName), this.samplePercent));
            }
        }
        for (MergedStatistic statistic : this.mergedStatisticList) {
            if (statistic.getName().equals("avg_width")) {
                ((AvgWidthMergedStatistic)statistic).configure(this.mergedStatisticList);
                continue;
            }
            if (statistic.getName().equals("approx_count_distinct")) {
                NDVMergedStatistic.NDVConfiguration config = new NDVMergedStatistic.NDVConfiguration(this.context.getOptions(), this.mergedStatisticList);
                ((NDVMergedStatistic)statistic).configure(config);
                continue;
            }
            if (statistic.getName().equals("sum")) {
                ((CntDupsMergedStatistic)statistic).configure(this.mergedStatisticList);
                continue;
            }
            if (statistic.getName().equals("hll_merge")) {
                ((HLLMergedStatistic)statistic).configure(this.context.getOptions());
                continue;
            }
            if (!statistic.getName().equals("tdigest_merge")) continue;
            ((TDigestMergedStatistic)statistic).configure(this.context.getOptions());
        }
        this.createKeyColumn("schema", ValueExpressions.getBigInt(this.schema++));
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(System.currentTimeMillis());
        this.createKeyColumn("computed", ValueExpressions.getDate(calendar));
        for (MergedStatistic statistic : this.mergedStatisticList) {
            String targetTypeStatistic = statistic.getInput();
            for (VectorWrapper vw : this.incoming) {
                if (!targetTypeStatistic.equals(vw.getField().getName())) continue;
                this.addVectorToOutgoingContainer(statistic.getName(), vw);
            }
        }
        this.container.setEmpty();
        this.container.buildSchema(this.incoming.getSchema().getSelectionVectorMode());
    }

    private void addVectorToOutgoingContainer(String outStatName, VectorWrapper<?> vw) {
        MapVector inputVector = (MapVector)vw.getValueVector();
        assert (inputVector.getPrimitiveVectors().size() > 0);
        TypeProtos.MajorType mt = inputVector.getField().getType();
        MaterializedField mf = MaterializedField.create(outStatName, mt);
        ValueVector outputValueVector = TypeHelper.getNewVector(mf, this.oContext.getAllocator());
        this.container.add(outputValueVector);
        MapVector outputVector = (MapVector)outputValueVector;
        for (ValueVector vv : inputVector) {
            String columnName = vv.getField().getName();
            if (outStatName.equals("column") || outStatName.equals("majortype")) {
                outputVector.addOrGet(columnName, vv.getField().getType(), vv.getClass());
                continue;
            }
            TypeProtos.MinorType minorType = outStatName.equals("avg_width") ? TypeProtos.MinorType.FLOAT8 : (outStatName.equals("hll_merge") || outStatName.equals("tdigest_merge") ? TypeProtos.MinorType.VARBINARY : TypeProtos.MinorType.BIGINT);
            Class<? extends ValueVector> vvc = TypeHelper.getValueVectorClass(minorType, TypeProtos.DataMode.OPTIONAL);
            outputVector.addOrGet(columnName, Types.optional(minorType), vvc);
        }
    }

    private RecordBatch.IterOutcome buildOutgoingRecordBatch() {
        block0: for (VectorWrapper<?> vw : this.container) {
            ValueVector vv;
            String outputStatName = vw.getField().getName();
            if (outputStatName.equals("schema")) {
                vv = (BigIntVector)vw.getValueVector();
                ((BigIntVector)vv).allocateNewSafe();
                ((BigIntVector)vv).getMutator().setSafe(0, this.schema);
                continue;
            }
            if (outputStatName.equals("computed")) {
                GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                DateVector vv2 = (DateVector)vw.getValueVector();
                vv2.allocateNewSafe();
                vv2.getMutator().setSafe(0, cal.getTimeInMillis());
                continue;
            }
            vv = (MapVector)vw.getValueVector();
            for (MergedStatistic outputStat : this.mergedStatisticList) {
                if (!outputStatName.equals(outputStat.getName())) continue;
                outputStat.setOutput((MapVector)vv);
                ((MapVector)vv).getMutator().setValueCount(this.columnsList.size());
                continue block0;
            }
        }
        this.container.setValueCount(1);
        return RecordBatch.IterOutcome.OK;
    }

    @Override
    protected boolean setupNewSchema() {
        this.container.clear();
        this.buildColumnsList();
        this.buildOutputContainer();
        return true;
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        block0: for (MergedStatistic outputStat : this.mergedStatisticList) {
            String inputStat = outputStat.getInput();
            for (VectorWrapper vw : this.incoming) {
                MapVector vv = (MapVector)vw.getValueVector();
                if (!vv.getField().getName().equals(inputStat)) continue;
                outputStat.merge(vv);
                continue block0;
            }
        }
        return RecordBatch.IterOutcome.OK;
    }

    @Override
    public VectorContainer getOutgoingContainer() {
        return this.container;
    }

    @Override
    public void dump() {
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch.IterOutcome out;
        RecordBatch.IterOutcome outcome;
        boolean didSomeWork = false;
        if (this.finished) {
            return RecordBatch.IterOutcome.NONE;
        }
        block6: while (true) {
            outcome = this.next(this.incoming);
            switch (outcome) {
                case NONE: {
                    break block6;
                }
                case NOT_YET: {
                    return outcome;
                }
                case OK_NEW_SCHEMA: {
                    if (this.first) {
                        this.first = false;
                        if (!this.setupNewSchema()) {
                            outcome = RecordBatch.IterOutcome.OK;
                        }
                        return outcome;
                    }
                }
                case OK: {
                    assert (!this.first) : "First batch should be OK_NEW_SCHEMA";
                    out = this.doWork();
                    didSomeWork = true;
                    if (out == RecordBatch.IterOutcome.OK) continue block6;
                    return out;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported upstream state " + (Object)((Object)outcome));
                }
            }
            break;
        }
        if (didSomeWork) {
            out = this.buildOutgoingRecordBatch();
            this.finished = true;
            return out;
        }
        return outcome;
    }

    @Override
    public int getRecordCount() {
        return this.container.getRecordCount();
    }
}

