/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class NNRowCountMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, Long> sumHolder = new HashMap<String, Long>();

    public NNRowCountMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("nonnullrowcount", inputName, samplePercent);
        this.state = Statistic.State.MERGE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector vv : input) {
            String colName = vv.getField().getName();
            NullableBigIntVector biv = (NullableBigIntVector)vv;
            NullableBigIntVector.Accessor accessor = biv.getAccessor();
            long sum = 0L;
            if (this.sumHolder.get(colName) != null) {
                sum = this.sumHolder.get(colName);
            }
            if (accessor.isNull(0)) continue;
            this.sumHolder.put(colName, sum += accessor.get(0));
        }
    }

    public long getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return (long)(100.0 * (double)this.sumHolder.get(colName).longValue() / this.samplePercent);
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            NullableBigIntVector vv = (NullableBigIntVector)outMapCol;
            vv.allocateNewSafe();
            if (this.sumHolder.get(colName) != null) {
                vv.getMutator().setSafe(0, (long)(100.0 * (double)this.sumHolder.get(colName).longValue() / this.samplePercent));
                continue;
            }
            vv.getMutator().setNull(0);
        }
        this.state = Statistic.State.COMPLETE;
    }
}

