/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import java.nio.charset.StandardCharsets;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class ColumnMergedStatistic
extends AbstractMergedStatistic {
    public ColumnMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("column", inputName, samplePercent);
        this.state = Statistic.State.MERGE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        MapVector outputMap = output;
        for (ValueVector outMapCol : outputMap) {
            String colName = outMapCol.getField().getName();
            VarCharVector vv = (VarCharVector)outMapCol;
            vv.allocateNewSafe();
            vv.getMutator().setSafe(0, colName.getBytes(StandardCharsets.UTF_8), 0, colName.length());
        }
        this.state = Statistic.State.COMPLETE;
    }
}

