/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.statistics;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.impl.statistics.AbstractMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.ColTypeMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.MergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.NNRowCountMergedStatistic;
import org.apache.drill.exec.physical.impl.statistics.RowCountMergedStatistic;
import org.apache.drill.exec.record.MajorTypeSerDe;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.metastore.statistics.Statistic;

public class AvgWidthMergedStatistic
extends AbstractMergedStatistic {
    private Map<String, Double> sumHolder = new HashMap<String, Double>();
    ColTypeMergedStatistic types = null;
    NNRowCountMergedStatistic nonNullStatCounts = null;
    RowCountMergedStatistic statCounts = null;

    public AvgWidthMergedStatistic() {
        this.state = Statistic.State.INIT;
    }

    @Override
    public void initialize(String inputName, double samplePercent) {
        super.initialize("avg_width", inputName, samplePercent);
        this.state = Statistic.State.CONFIG;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.inputName;
    }

    @Override
    public void merge(MapVector input) {
        assert (input.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        for (ValueVector vv : input) {
            NullableFloat8Vector fv = (NullableFloat8Vector)vv;
            NullableFloat8Vector.Accessor accessor = fv.getAccessor();
            String colName = vv.getField().getName();
            double sum = 0.0;
            if (this.sumHolder.get(colName) != null) {
                sum = this.sumHolder.get(colName);
            }
            if (accessor.isNull(0)) continue;
            this.sumHolder.put(colName, sum += accessor.get(0));
        }
    }

    public double getStat(String colName) {
        if (this.state != Statistic.State.COMPLETE) {
            throw new IllegalStateException(String.format("Statistic `%s` has not completed merging statistics", this.name));
        }
        return this.sumHolder.get(colName) / (this.samplePercent / 100.0 * (double)this.getRowCount(colName));
    }

    @Override
    public void setOutput(MapVector output) {
        assert (output.getField().getType().getMinorType() == TypeProtos.MinorType.MAP);
        assert (this.state == Statistic.State.MERGE);
        for (ValueVector outMapCol : output) {
            String colName = outMapCol.getField().getName();
            NullableFloat8Vector vv = (NullableFloat8Vector)outMapCol;
            vv.allocateNewSafe();
            if (this.sumHolder.get(colName) != null && this.getRowCount(colName) > 0L) {
                vv.getMutator().setSafe(0, this.sumHolder.get(colName) / (this.samplePercent / 100.0 * (double)this.getRowCount(colName)));
                continue;
            }
            vv.getMutator().setNull(0);
        }
        this.state = Statistic.State.COMPLETE;
    }

    public void configure(List<MergedStatistic> statisticList) {
        assert (this.state == Statistic.State.CONFIG);
        for (MergedStatistic statistic : statisticList) {
            if (statistic.getName().equals("majortype")) {
                this.types = (ColTypeMergedStatistic)statistic;
                continue;
            }
            if (statistic.getName().equals("rowcount")) {
                this.statCounts = (RowCountMergedStatistic)statistic;
                continue;
            }
            if (!statistic.getName().equals("nonnullrowcount")) continue;
            this.nonNullStatCounts = (NNRowCountMergedStatistic)statistic;
        }
        assert (this.types != null && this.statCounts != null && this.nonNullStatCounts != null);
        this.state = Statistic.State.MERGE;
    }

    private long getRowCount(String colName) {
        byte[] typeAsBytes = this.types.getStat(colName);
        int type = -1;
        SimpleModule deModule = new SimpleModule("StatisticsSerDeModule").addDeserializer(TypeProtos.MajorType.class, (JsonDeserializer)new MajorTypeSerDe.De());
        ObjectMapper mapper = ((JsonMapper.Builder)JacksonUtils.createJsonMapperBuilder().addModule((Module)deModule)).build();
        try {
            type = ((TypeProtos.MajorType)mapper.readValue(typeAsBytes, TypeProtos.MajorType.class)).getMinorType().getNumber();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (type == TypeProtos.MinorType.VAR16CHAR.getNumber() || type == TypeProtos.MinorType.VARCHAR.getNumber() || type == TypeProtos.MinorType.VARBINARY.getNumber()) {
            return this.nonNullStatCounts.getStat(colName);
        }
        return this.statCounts.getStat(colName);
    }
}

