/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.sort.Sorter;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.selection.SelectionVector4;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.QuickSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortTemplate
implements Sorter,
IndexedSortable {
    static final Logger logger = LoggerFactory.getLogger(SortTemplate.class);
    private SelectionVector4 vector4;

    @Override
    public void setup(FragmentContext context, SelectionVector4 vector4, VectorContainer hyperBatch) throws SchemaChangeException {
        Preconditions.checkNotNull(vector4);
        this.vector4 = vector4;
        this.doSetup(context, hyperBatch, null);
    }

    @Override
    public void sort(SelectionVector4 vector4, VectorContainer container) {
        Stopwatch watch = Stopwatch.createStarted();
        QuickSort qs = new QuickSort();
        qs.sort((IndexedSortable)this, 0, vector4.getTotalCount());
        logger.debug("Took {} us to sort {} records", (Object)watch.elapsed(TimeUnit.MICROSECONDS), (Object)vector4.getTotalCount());
    }

    public void swap(int sv0, int sv1) {
        int tmp = this.vector4.get(sv0);
        this.vector4.set(sv0, this.vector4.get(sv1));
        this.vector4.set(sv1, tmp);
    }

    public int compare(int leftIndex, int rightIndex) {
        int sv1 = this.vector4.get(leftIndex);
        int sv2 = this.vector4.get(rightIndex);
        return this.doEval(sv1, sv2);
    }

    public abstract void doSetup(@Named(value="context") FragmentContext var1, @Named(value="incoming") VectorContainer var2, @Named(value="outgoing") RecordBatch var3);

    public abstract int doEval(@Named(value="leftIndex") int var1, @Named(value="rightIndex") int var2);

    public String toString() {
        return "SortTemplate[vector4=" + this.vector4 + "]";
    }
}

