/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.setop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.sql.SqlKind;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.config.SetOp;
import org.apache.drill.exec.physical.impl.common.Comparator;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.join.AbstractHashBinaryRecordBatch;
import org.apache.drill.exec.physical.impl.join.Probe;
import org.apache.drill.exec.physical.impl.setop.HashSetOpProbeTemplate;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class HashSetOpRecordBatch
extends AbstractHashBinaryRecordBatch<SetOp> {
    private final SqlKind opType;
    private final boolean isAll;

    public HashSetOpRecordBatch(SetOp popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, left, right);
        this.opType = popConfig.getKind();
        this.isAll = popConfig.isAll();
        this.semiJoin = true;
        this.joinIsLeftOrFull = true;
        this.joinIsRightOrFull = false;
        this.isRowKeyJoin = false;
        this.enableRuntimeFilter = false;
    }

    private void buildCompareExpression(List<NamedExpression> leftExpr, List<Comparator> comparators) {
        String refName;
        MaterializedField field;
        Iterator<MaterializedField> iterator = this.probeSchema.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            field = iterator.next();
            refName = "probe_side_" + i;
            leftExpr.add(new NamedExpression(new FieldReference(field.getName()), new FieldReference(refName)));
            ++i;
        }
        iterator = this.buildSchema.iterator();
        i = 0;
        while (iterator.hasNext()) {
            field = iterator.next();
            refName = "build_side_" + i;
            this.rightExpr.add(new NamedExpression(new FieldReference(field.getName()), new FieldReference(refName)));
            this.buildJoinColumns.add(field.getName());
            ++i;
        }
        leftExpr.forEach(e -> comparators.add(Comparator.EQUALS));
    }

    @Override
    protected HashTableConfig buildHashTableConfig() {
        if ((this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA || this.leftUpstream == RecordBatch.IterOutcome.OK) && this.probeBatch.getSchema().getSelectionVectorMode() != BatchSchema.SelectionVectorMode.NONE) {
            throw UserException.internalError(null).message("Hash SetOp does not support probe batch with selection vectors.", new Object[0]).addContext("Probe batch has selection mode", this.probeBatch.getSchema().getSelectionVectorMode().toString()).build(this.logger);
        }
        ArrayList<NamedExpression> leftExpr = Lists.newArrayListWithExpectedSize(this.probeSchema.getFieldCount());
        ArrayList<Comparator> comparators = Lists.newArrayListWithExpectedSize(this.probeSchema.getFieldCount());
        this.buildCompareExpression(leftExpr, comparators);
        return new HashTableConfig((int)this.context.getOptions().getOption(ExecConstants.MIN_HASH_TABLE_SIZE), true, 0.75f, this.rightExpr, leftExpr, comparators, 0, true);
    }

    @Override
    public Probe createProbe() {
        return new HashSetOpProbeTemplate();
    }

    @Override
    public void setupProbe() throws SchemaChangeException {
        this.probe.setup(this.probeBatch, this, this.opType, this.isAll, this.leftUpstream, this.partitions, this.spilledState.getCycle(), this.container, this.spilledInners, this.buildSideIsEmpty.booleanValue(), this.numPartitions);
    }

    @Override
    public void dump() {
        this.logger.error("HashSetOpRecordBatch[container={}, left={}, right={}, leftOutcome={}, rightOutcome={}, SetOpType={}, IsAll={}, hashSetOpProbe={}, canSpill={}, buildSchema={}, probeSchema={}]", new Object[]{this.container, this.left, this.right, this.leftUpstream, this.rightUpstream, this.opType, this.isAll, this.probe, this.canSpill, this.buildSchema, this.probeSchema});
    }
}

