/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanProjectionParser;
import org.apache.drill.exec.planner.sql.TypeInferenceUtils;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MapColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.Propertied;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);

    public static boolean isConsistent(ProjectedColumn colReq, ColumnMetadata readCol) {
        if (readCol.isDynamic()) {
            return true;
        }
        if (colReq.isMap() && !readCol.isMap() && !readCol.isDict() && !readCol.isVariant()) {
            return false;
        }
        if (colReq.isArray()) {
            if (colReq.arrayDims() == 1) {
                return readCol.isArray() || readCol.isDict() || readCol.isVariant();
            }
            return readCol.type() == TypeProtos.MinorType.LIST || readCol.isDict() || readCol.isVariant();
        }
        return true;
    }

    public static void verifyCompatibility(ProjectedColumn colReq, ColumnMetadata actual, String source, CustomErrorContext errorContext) {
        if (!SchemaUtils.isConsistent(colReq, actual)) {
            throw UserException.validationError().message(source + " column type not compatible with projection specification", new Object[0]).addContext("Projected column", colReq.projectString()).addContext(source + " column", actual.columnString()).addContext(errorContext).build(logger);
        }
    }

    public static void verifyConsistency(ColumnMetadata existing, ColumnMetadata revised, String source, CustomErrorContext errorContext) {
        if (existing.isDynamic() || revised.isDynamic()) {
            return;
        }
        if (existing.type() != revised.type() || existing.mode() != revised.mode()) {
            throw UserException.validationError().message("Scan and " + source + " column type conflict", new Object[0]).addContext("Scan column", existing.columnString()).addContext(source + " column", revised.columnString()).addContext(errorContext).build(logger);
        }
    }

    public static void verifyProjection(ColumnMetadata existing, ColumnMetadata revised, String source, CustomErrorContext errorContext) {
        if (existing instanceof ProjectedColumn) {
            SchemaUtils.verifyCompatibility((ProjectedColumn)existing, revised, source, errorContext);
        } else {
            SchemaUtils.verifyConsistency(existing, revised, source, errorContext);
        }
    }

    public static void mergeColProperties(ColumnMetadata existing, ColumnMetadata revised) {
        SchemaUtils.mergeProperties(existing, revised);
        if (existing.isMap() && revised.isMap()) {
            SchemaUtils.mergeProperties(existing.tupleSchema(), revised.tupleSchema());
        }
    }

    public static void mergeProperties(Propertied existing, Propertied revised) {
        if (!revised.hasProperties()) {
            return;
        }
        existing.properties().putAll(revised.properties());
    }

    public static boolean isStrict(TupleMetadata schema) {
        return schema.booleanProperty("drill.strict");
    }

    public static void markStrict(TupleMetadata schema) {
        schema.setBooleanProperty("drill.strict", true);
    }

    public static String implicitColType(ColumnMetadata col) {
        return col.property("drill.implicit");
    }

    public static boolean isImplicit(ColumnMetadata col) {
        return SchemaUtils.implicitColType(col) != null;
    }

    public static void markImplicit(ColumnMetadata col, String value) {
        col.setProperty("drill.implicit", value);
    }

    public static void markAsPartition(ColumnMetadata col, int level) {
        SchemaUtils.markImplicit(col, "dir" + level);
    }

    public static void markExcludeFromWildcard(ColumnMetadata col) {
        col.setBooleanProperty("drill.special", true);
    }

    public static boolean isExcludedFromWildcard(ColumnMetadata col) {
        return col.booleanProperty("drill.special");
    }

    public static ScanProjectionParser.ProjectionParseResult projectAll() {
        TupleSchema projSet = new TupleSchema();
        projSet.setProperty("drill.proj-type", "all");
        return new ScanProjectionParser.ProjectionParseResult(0, projSet);
    }

    public static void markProjectAll(ColumnMetadata col) {
        Preconditions.checkArgument(col.isMap());
        col.tupleSchema().setProperty("drill.proj-type", "all");
    }

    public static ScanProjectionParser.ProjectionParseResult projectNone() {
        TupleSchema projSet = new TupleSchema();
        projSet.setProperty("drill.proj-type", "none");
        return new ScanProjectionParser.ProjectionParseResult(-1, projSet);
    }

    public static boolean isProjectAll(TupleMetadata tuple) {
        return "all".equals(tuple.property("drill.proj-type"));
    }

    public static boolean isProjectNone(TupleMetadata tuple) {
        return "none".equals(tuple.property("drill.proj-type"));
    }

    public static void copyMapProperties(ProjectedColumn source, ColumnMetadata dest) {
        if (source != null && source.isMap()) {
            Preconditions.checkArgument(dest.isMap());
            SchemaUtils.copyProperties(source.tupleSchema(), dest.tupleSchema());
        } else {
            SchemaUtils.markProjectAll(dest);
        }
    }

    static void copyProperties(TupleMetadata source, TupleMetadata dest) {
        String value = source.property("drill.proj-type");
        if (value != null) {
            dest.setProperty("drill.proj-type", value);
        }
    }

    public static ColumnMetadata getColumnMetadata(String name, RelDataType relDataType) {
        switch (relDataType.getSqlTypeName()) {
            case ARRAY: {
                return SchemaUtils.getArrayMetadata(name, relDataType);
            }
            case MAP: 
            case OTHER: {
                throw new UnsupportedOperationException(String.format("Unsupported data type: %s", relDataType.getSqlTypeName()));
            }
        }
        if (relDataType.isStruct()) {
            return SchemaUtils.getStructMetadata(name, relDataType);
        }
        return new PrimitiveColumnMetadata(MaterializedField.create(name, TypeInferenceUtils.getDrillMajorTypeFromCalciteType(relDataType)));
    }

    private static ColumnMetadata getArrayMetadata(String name, RelDataType relDataType) {
        RelDataType componentType = relDataType.getComponentType();
        ColumnMetadata childColumnMetadata = SchemaUtils.getColumnMetadata(name, componentType);
        switch (componentType.getSqlTypeName()) {
            case ARRAY: {
                return MetadataUtils.newRepeatedList(name, childColumnMetadata);
            }
            case MAP: 
            case OTHER: {
                throw new UnsupportedOperationException(String.format("Unsupported data type: %s", relDataType.getSqlTypeName()));
            }
        }
        if (componentType.isStruct()) {
            return MetadataUtils.newMapArray(name, childColumnMetadata.tupleSchema());
        }
        return new PrimitiveColumnMetadata(MaterializedField.create(name, Types.overrideMode(TypeInferenceUtils.getDrillMajorTypeFromCalciteType(componentType), TypeProtos.DataMode.REPEATED)));
    }

    private static MapColumnMetadata getStructMetadata(String name, RelDataType relDataType) {
        TupleSchema mapSchema = new TupleSchema();
        relDataType.getFieldList().stream().map(field -> SchemaUtils.getColumnMetadata(field.getName(), field.getType())).filter(metadata -> metadata.type() != TypeProtos.MinorType.LATE).forEach(mapSchema::addColumn);
        return MetadataUtils.newMap(name, (TupleMetadata)mapSchema);
    }
}

