/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.v3.schema.DynamicSchemaFilter;
import org.apache.drill.exec.physical.impl.scan.v3.schema.MutableTupleSchema;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DynamicColumn;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanSchemaResolver {
    private static final Logger logger = LoggerFactory.getLogger(ScanSchemaResolver.class);
    private final MutableTupleSchema schema;
    private final SchemaType mode;
    private final boolean allowMapAdditions;
    private final String source;
    private final CustomErrorContext errorContext;
    private final boolean allowColumnReorder;

    public ScanSchemaResolver(MutableTupleSchema schema, SchemaType mode, boolean allowMapAdditions, CustomErrorContext errorContext) {
        this.schema = schema;
        this.mode = mode;
        this.errorContext = errorContext;
        this.allowMapAdditions = allowMapAdditions;
        this.source = mode.source();
        switch (mode) {
            case STRICT_PROVIDED_SCHEMA: 
            case LENIENT_PROVIDED_SCHEMA: 
            case EARLY_READER_SCHEMA: 
            case FIRST_READER_SCHEMA: {
                this.allowColumnReorder = schema.projectionType() == ScanSchemaTracker.ProjectionType.ALL;
                break;
            }
            default: {
                this.allowColumnReorder = false;
            }
        }
    }

    public void applySchema(TupleMetadata sourceSchema) {
        switch (this.schema.projectionType()) {
            case ALL: {
                this.projectSchema(sourceSchema);
                if (this.mode != SchemaType.STRICT_PROVIDED_SCHEMA) break;
                this.schema.setProjectionType(ScanSchemaTracker.ProjectionType.SOME);
                break;
            }
            case SOME: {
                this.projectSchema(sourceSchema);
                break;
            }
        }
    }

    private void projectSchema(TupleMetadata sourceSchema) {
        for (ColumnMetadata colSchema : sourceSchema) {
            MutableTupleSchema.ColumnHandle existing = this.schema.find(colSchema.name());
            if (existing == null) {
                this.insertColumn(colSchema);
                continue;
            }
            this.mergeColumn(existing, colSchema);
            if (!this.allowColumnReorder) continue;
            this.schema.moveIfExplicit(colSchema.name());
        }
    }

    private void insertColumn(ColumnMetadata col) {
        switch (this.mode) {
            case FIRST_READER_SCHEMA: 
            case READER_SCHEMA: {
                if (this.schema.projectionType() == ScanSchemaTracker.ProjectionType.ALL) break;
                throw new IllegalStateException("Reader should not have projected an unprojected column: " + col.name());
            }
            case STRICT_PROVIDED_SCHEMA: 
            case LENIENT_PROVIDED_SCHEMA: 
            case EARLY_READER_SCHEMA: {
                if (this.schema.projectionType() == ScanSchemaTracker.ProjectionType.ALL && !SchemaUtils.isExcludedFromWildcard(col)) break;
                return;
            }
            case MISSING_COLS: {
                throw new IllegalStateException("Missing columns should not add new columns");
            }
            default: {
                throw new IllegalStateException(this.mode.name());
            }
        }
        ColumnMetadata copy = col.copy();
        this.schema.insert(copy);
        if (copy.isMap() && this.mode != SchemaType.STRICT_PROVIDED_SCHEMA) {
            SchemaUtils.markProjectAll(copy);
        }
    }

    private void mergeColumn(MutableTupleSchema.ColumnHandle col, ColumnMetadata colSchema) {
        switch (this.mode) {
            case STRICT_PROVIDED_SCHEMA: 
            case LENIENT_PROVIDED_SCHEMA: {
                break;
            }
            case EARLY_READER_SCHEMA: {
                if (!col.isImplicit()) break;
                logger.warn("Column {} shadows an implicit column of the same name: ignored", (Object)colSchema.name());
                return;
            }
            default: {
                if (!col.isImplicit()) break;
                throw UserException.validationError().message("Reader column conflicts an implicit column, should not have been projected", new Object[0]).addContext("Column", colSchema.name()).addContext(this.errorContext).build(logger);
            }
        }
        if (col.column().isDynamic()) {
            this.mergeColumnWithDynamic(col, colSchema);
        } else {
            this.mergeWithConcrete(col.column(), colSchema);
        }
    }

    private void mergeColumnWithDynamic(MutableTupleSchema.ColumnHandle existing, ColumnMetadata revised) {
        DynamicColumn existingCol = (DynamicColumn)existing.column();
        if (existingCol instanceof ProjectedColumn) {
            SchemaUtils.verifyCompatibility((ProjectedColumn)existingCol, revised, this.source, this.errorContext);
        }
        if (existingCol.isMap() || revised.isMap()) {
            this.schema.replace(existing, this.createMap(existingCol, revised));
        } else {
            this.schema.resolve(existing, revised.copy());
        }
    }

    private void mergeWithConcrete(ColumnMetadata existing, ColumnMetadata revised) {
        SchemaUtils.verifyConsistency(existing, revised, this.source, this.errorContext);
        if (existing.isMap()) {
            DynamicSchemaFilter.DynamicTupleFilter filter = new DynamicSchemaFilter.DynamicTupleFilter(existing.tupleSchema(), this.allowMapAdditions, this.errorContext, this.source);
            this.expandMapProjection(existing.tupleSchema(), filter, revised.tupleSchema());
        }
    }

    private ColumnMetadata createMap(DynamicColumn projection, ColumnMetadata revised) {
        return this.createMap(projection, DynamicSchemaFilter.DynamicTupleFilter.filterFor(projection, this.allowMapAdditions, this.errorContext, this.source), revised);
    }

    private ColumnMetadata createMap(DynamicColumn projection, ProjectionFilter filter, ColumnMetadata revised) {
        ColumnMetadata map = revised.cloneEmpty();
        SchemaUtils.mergeColProperties(map, projection);
        SchemaUtils.mergeColProperties(map, revised);
        this.copyDynamicMembers(map, projection);
        if (!projection.isMap() && this.mode != SchemaType.STRICT_PROVIDED_SCHEMA) {
            SchemaUtils.markProjectAll(map);
        }
        this.expandMapProjection(map.tupleSchema(), filter, revised.tupleSchema());
        return map;
    }

    private void copyDynamicMembers(ColumnMetadata map, DynamicColumn projection) {
        if (projection.isMap()) {
            TupleMetadata mapSchema = map.tupleSchema();
            for (ColumnMetadata col : projection.tupleSchema()) {
                mapSchema.addColumn(col.copy());
            }
        }
    }

    private void expandMapProjection(TupleMetadata scanSchema, ProjectionFilter filter, TupleMetadata revisedSchema) {
        for (ColumnMetadata readerCol : revisedSchema) {
            this.resolveMember(scanSchema, filter.projection(readerCol), readerCol);
        }
    }

    private void resolveMember(TupleMetadata scanSchema, ProjectionFilter.ProjResult result, ColumnMetadata readerCol) {
        block14: {
            ColumnMetadata schemaCol;
            block13: {
                schemaCol = result.projection;
                if (result.isProjected) break block13;
                switch (this.mode) {
                    case STRICT_PROVIDED_SCHEMA: 
                    case LENIENT_PROVIDED_SCHEMA: 
                    case EARLY_READER_SCHEMA: {
                        break block14;
                    }
                    case FIRST_READER_SCHEMA: 
                    case READER_SCHEMA: {
                        if (!this.allowMapAdditions) {
                            throw new IllegalStateException("Reader should not have projected column: " + readerCol.name());
                        }
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException(this.mode.name());
                    }
                }
            }
            if (schemaCol == null) {
                ColumnMetadata copy = readerCol.copy();
                if (readerCol.isMap()) {
                    SchemaUtils.markProjectAll(copy);
                }
                scanSchema.addColumn(copy);
            } else if (schemaCol.isDynamic()) {
                if (schemaCol.isMap()) {
                    scanSchema.replace(this.createMap((ProjectedColumn)schemaCol, result.mapFilter, readerCol));
                } else {
                    scanSchema.replace(readerCol.copy());
                }
            } else if (schemaCol.isMap()) {
                this.expandMapProjection(schemaCol.tupleSchema(), result.mapFilter, readerCol.tupleSchema());
            }
        }
    }

    public static enum SchemaType {
        STRICT_PROVIDED_SCHEMA("Provided"),
        LENIENT_PROVIDED_SCHEMA("Provided"),
        EARLY_READER_SCHEMA("Reader"),
        FIRST_READER_SCHEMA("Reader"),
        READER_SCHEMA("Reader"),
        MISSING_COLS("Missing columns");

        private final String source;

        private SchemaType(String source) {
            this.source = source;
        }

        public String source() {
            return this.source;
        }
    }
}

