/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import java.util.Collections;
import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.EmptyErrorContext;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectionSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanProjectionParser;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaBasedTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ScanSchemaConfigBuilder {
    private TupleMetadata definedSchema;
    private List<SchemaPath> projectionList = Collections.singletonList(SchemaPath.STAR_COLUMN);
    private TupleMetadata providedSchema;
    private boolean allowSchemaChange = true;
    private CustomErrorContext errorContext;

    public ScanSchemaConfigBuilder projection(List<SchemaPath> projectionList) {
        this.projectionList = projectionList;
        return this;
    }

    public ScanSchemaConfigBuilder definedSchema(TupleMetadata definedSchema) {
        this.definedSchema = definedSchema;
        return this;
    }

    public ScanSchemaConfigBuilder providedSchema(TupleMetadata providedSchema) {
        this.providedSchema = providedSchema;
        return this;
    }

    public ScanSchemaConfigBuilder allowSchemaChange(boolean flag) {
        this.allowSchemaChange = flag;
        return this;
    }

    public ScanSchemaConfigBuilder errorContext(CustomErrorContext errorContext) {
        this.errorContext = errorContext;
        return this;
    }

    public ScanSchemaTracker build() {
        if (this.errorContext == null) {
            this.errorContext = EmptyErrorContext.INSTANCE;
        }
        ScanProjectionParser.ProjectionParseResult result = this.projectionList == null ? null : ScanProjectionParser.parse(this.projectionList);
        if (this.providedSchema != null && SchemaUtils.isStrict(this.providedSchema)) {
            this.allowSchemaChange = false;
        }
        if (this.definedSchema == null) {
            ProjectionSchemaTracker tracker = new ProjectionSchemaTracker(result, this.allowSchemaChange, this.errorContext);
            if (this.providedSchema != null) {
                tracker.applyProvidedSchema(this.providedSchema);
            }
            return tracker;
        }
        if (!MetadataUtils.hasDynamicColumns(this.definedSchema)) {
            SchemaBasedTracker tracker = new SchemaBasedTracker(this.definedSchema, this.errorContext);
            if (result != null) {
                tracker.validateProjection(result.dynamicSchema);
            }
            return tracker;
        }
        return new ProjectionSchemaTracker(this.definedSchema, result, this.errorContext);
    }
}

