/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import java.util.Collection;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class ScanProjectionParser {
    public static final String PROJECTION_TYPE_PROP = "drill.proj-type";
    public static final String PROJECT_ALL = "all";
    public static final String PROJECT_NONE = "none";
    private int wildcardPosn = -1;

    public static ProjectionParseResult parse(Collection<SchemaPath> projList) {
        if (projList == null) {
            return SchemaUtils.projectAll();
        }
        if (projList.isEmpty()) {
            return SchemaUtils.projectNone();
        }
        return new ScanProjectionParser().parseProjection(projList);
    }

    private ProjectionParseResult parseProjection(Collection<SchemaPath> projList) {
        TupleSchema tupleProj = new TupleSchema();
        for (SchemaPath col : projList) {
            this.parseMember(tupleProj, 0, col.getRootSegment());
        }
        return new ProjectionParseResult(this.wildcardPosn, tupleProj);
    }

    private void parseMember(TupleMetadata tuple, int depth, PathSegment.NameSegment nameSeg) {
        String colName = nameSeg.getPath();
        if (colName.equals("**")) {
            tuple.setProperty(PROJECTION_TYPE_PROP, PROJECT_ALL);
            if (depth == 0) {
                Preconditions.checkState(this.wildcardPosn == -1);
                this.wildcardPosn = tuple.size();
            }
        } else {
            ProjectedColumn col = this.project(tuple, nameSeg.getPath());
            this.parseChildSeg(col, depth + 1, nameSeg);
        }
    }

    protected ProjectedColumn project(TupleMetadata tuple, String colName) {
        ProjectedColumn projCol;
        ColumnMetadata col = tuple.metadata(colName);
        if (col == null) {
            projCol = new ProjectedColumn(colName);
            tuple.addColumn(projCol);
        } else {
            projCol = (ProjectedColumn)col;
            projCol.bumpRefCount();
        }
        return projCol;
    }

    private void parseChildSeg(ProjectedColumn column, int depth, PathSegment parentPath) {
        if (parentPath.isLastPath()) {
            this.parseLeaf(column, depth);
        } else {
            PathSegment seg = parentPath.getChild();
            if (seg.isArray()) {
                this.parseArraySeg(column, depth, (PathSegment.ArraySegment)seg);
            } else {
                this.parseMemberSeg(column, depth, (PathSegment.NameSegment)seg);
            }
        }
    }

    private void parseLeaf(ProjectedColumn parent, int depth) {
        if (!parent.isSimple()) {
            if (parent.isArray() && depth == 1) {
                parent.projectAllElements();
            } else if (parent.isMap()) {
                parent.projectAllMembers();
            }
        }
    }

    private void parseArraySeg(ProjectedColumn column, int depth, PathSegment.ArraySegment arraySeg) {
        boolean wasArray = column.isArray();
        column.becomeArray(Math.max(depth, column.arrayDims()));
        if (depth == 1) {
            if (column.refCount() > 1 && !wasArray) {
                column.projectAllElements();
            } else {
                column.addIndex(arraySeg.getIndex());
            }
        }
        this.parseChildSeg(column, depth + 1, arraySeg);
    }

    private void parseMemberSeg(ProjectedColumn column, int depth, PathSegment.NameSegment memberSeg) {
        TupleMetadata tuple;
        if (column.refCount() > 1 && !column.isMap()) {
            column.projectAllMembers();
        }
        if ((tuple = column.explicitMembers()) != null) {
            this.parseMember(tuple, depth, memberSeg);
        }
    }

    public static class ProjectionParseResult {
        public final int wildcardPosn;
        public final TupleMetadata dynamicSchema;

        public ProjectionParseResult(int wildcardPosn, TupleMetadata dynamicSchema) {
            this.wildcardPosn = wildcardPosn;
            this.dynamicSchema = dynamicSchema;
        }

        public boolean isProjectAll() {
            return this.wildcardPosn != -1;
        }
    }
}

