/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DynamicColumn;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;

public class ProjectedColumn
extends DynamicColumn {
    private static final Set<Integer> ALL_INDEXES = new HashSet<Integer>();
    private int refCount = 1;
    private int arrayDims;
    private Set<Integer> indexes;
    private TupleMetadata members;

    public ProjectedColumn(String name) {
        super(name);
    }

    protected void bumpRefCount() {
        ++this.refCount;
    }

    public int refCount() {
        return this.refCount;
    }

    public boolean isSimple() {
        return !this.isArray() && !this.isMap();
    }

    @Override
    public boolean isMap() {
        return this.members != null;
    }

    public void projectAllElements() {
        this.indexes = ALL_INDEXES;
    }

    public void becomeArray(int dims) {
        this.arrayDims = dims;
        this.indexes = this.indexes == null ? new HashSet() : this.indexes;
    }

    public int arrayDims() {
        return this.arrayDims;
    }

    @Override
    public boolean isArray() {
        return this.arrayDims > 0;
    }

    protected void addIndex(int index) {
        if (this.indexes == null) {
            this.indexes = new HashSet<Integer>();
        }
        if (this.indexes != ALL_INDEXES) {
            this.indexes.add(index);
        }
    }

    public boolean hasIndexes() {
        return this.isArray() && this.indexes != ALL_INDEXES;
    }

    public boolean hasIndex(int index) {
        return this.hasIndexes() && this.indexes.contains(index);
    }

    public int maxIndex() {
        if (!this.hasIndexes()) {
            return 0;
        }
        int max = 0;
        for (Integer index : this.indexes) {
            max = Math.max(max, index);
        }
        return max;
    }

    public boolean[] indexes() {
        if (!this.hasIndexes()) {
            return null;
        }
        int max = this.maxIndex();
        boolean[] map = new boolean[max + 1];
        for (Integer index : this.indexes) {
            map[index.intValue()] = true;
        }
        return map;
    }

    public void projectAllMembers() {
        if (this.members == null) {
            this.members = new TupleSchema();
        }
        this.members.setProperty("drill.proj-type", "all");
    }

    public TupleMetadata explicitMembers() {
        if (this.members == null) {
            this.members = new TupleSchema();
        }
        return this.members;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.members;
    }

    @Override
    protected void appendContents(StringBuilder buf) {
        this.appendArray(buf);
        if (this.isMap()) {
            buf.append(" members=").append(this.members.toString());
        }
    }

    private void appendArray(StringBuilder buf) {
        if (this.isArray()) {
            buf.append("[");
            if (this.indexes == ALL_INDEXES) {
                buf.append("*");
            } else {
                List idxs = this.indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.toList());
                buf.append(String.join((CharSequence)", ", idxs));
            }
            buf.append("]");
        }
    }

    @Override
    public ColumnMetadata copy() {
        ProjectedColumn copy = new ProjectedColumn(this.name);
        copy.refCount = this.refCount;
        copy.arrayDims = this.arrayDims;
        copy.indexes = this.indexes;
        copy.members = this.members == null ? null : this.members.copy();
        return copy;
    }

    public String projectString() {
        StringBuilder buf = new StringBuilder().append(this.name);
        this.appendArray(buf);
        if (this.isMap()) {
            buf.append(" {");
            int i = 0;
            for (ColumnMetadata child : this.members) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                if (child instanceof ProjectedColumn) {
                    buf.append(((ProjectedColumn)child).projectString());
                    continue;
                }
                buf.append(child.toString());
            }
            buf.append("}");
        }
        return buf.toString();
    }
}

