/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnMarker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class MutableTupleSchema {
    protected final List<ColumnHandle> columns = new ArrayList<ColumnHandle>();
    protected final Map<String, ColumnHandle> nameIndex = CaseInsensitiveMap.newHashMap();
    private ScanSchemaTracker.ProjectionType projType;
    private int insertPoint = -1;
    private int version;

    public void setProjectionType(ScanSchemaTracker.ProjectionType type) {
        this.projType = type;
        ++this.version;
    }

    public void setInsertPoint(int insertPoint) {
        Preconditions.checkArgument(insertPoint == -1 || insertPoint >= 0 && insertPoint <= this.size());
        this.insertPoint = insertPoint;
    }

    public ScanSchemaTracker.ProjectionType projectionType() {
        return this.projType;
    }

    public int size() {
        return this.columns.size();
    }

    public int version() {
        return this.version;
    }

    public List<ColumnHandle> columns() {
        return this.columns;
    }

    public ColumnHandle find(String colName) {
        return this.nameIndex.get(colName);
    }

    public void copyFrom(TupleMetadata from) {
        if (from.isEmpty()) {
            return;
        }
        for (ColumnMetadata projCol : from) {
            this.add(projCol.copy());
        }
        ++this.version;
    }

    public void add(ColumnMetadata col) {
        ColumnHandle holder = new ColumnHandle(col);
        this.columns.add(holder);
        this.addIndex(holder);
        ++this.version;
    }

    public void addIndex(ColumnHandle holder) {
        if (this.nameIndex.put(holder.column().name(), holder) != null) {
            throw new IllegalArgumentException("Duplicate scan projection column: " + holder.name());
        }
    }

    public ColumnHandle insert(int posn, ColumnMetadata col) {
        ColumnHandle holder = new ColumnHandle(col);
        this.columns.add(posn, holder);
        this.addIndex(holder);
        ++this.version;
        return holder;
    }

    public ColumnHandle insert(ColumnMetadata col) {
        switch (this.projType) {
            case SOME: {
                return this.insert(this.columns.size(), col);
            }
            case ALL: {
                return this.insert(this.insertPoint++, col);
            }
        }
        throw new IllegalArgumentException("No projection, should not have materialized: " + col.name());
    }

    public void moveIfExplicit(String colName) {
        ColumnHandle holder = this.find(colName);
        Objects.requireNonNull(holder);
        int posn = this.columns.indexOf(holder);
        if (posn == this.insertPoint) {
            ++this.insertPoint;
        } else if (posn > this.insertPoint) {
            this.columns.remove(posn);
            this.columns.add(this.insertPoint++, holder);
            ++this.version;
        }
    }

    public boolean isResolved() {
        for (ColumnHandle handle : this.columns) {
            if (this.isColumnResolved(handle.column())) continue;
            return false;
        }
        return true;
    }

    private boolean isColumnResolved(ColumnMetadata col) {
        return !col.isDynamic() && (!col.isMap() || this.isMapResolved(col.tupleSchema()));
    }

    private boolean isMapResolved(TupleMetadata mapSchema) {
        for (ColumnMetadata col : mapSchema) {
            if (col.isDynamic()) {
                return false;
            }
            if (!col.isMap() || this.isMapResolved(col.tupleSchema())) continue;
            return false;
        }
        return true;
    }

    public TupleMetadata toSchema() {
        TupleSchema schema = new TupleSchema();
        for (ColumnHandle col : this.columns) {
            schema.addColumn(col.column());
        }
        return schema;
    }

    public void resolveImplicit(ColumnHandle col, ColumnMetadata resolved, ImplicitColumnMarker marker) {
        col.resolveImplicit(resolved, marker);
        ++this.version;
    }

    public void replace(ColumnHandle col, ColumnMetadata resolved) {
        col.replace(resolved);
        ++this.version;
    }

    public void resolve(ColumnHandle col, ColumnMetadata resolved) {
        col.resolve(resolved);
        ++this.version;
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public static class ColumnHandle {
        private ColumnMetadata col;
        private ImplicitColumnMarker marker;

        public ColumnHandle(ColumnMetadata col) {
            this.col = col;
        }

        public String name() {
            return this.col.name();
        }

        private void replace(ColumnMetadata col) {
            this.col = col;
        }

        private void resolve(ColumnMetadata col) {
            SchemaUtils.mergeColProperties(this.col, col);
            this.col = col;
        }

        private void resolveImplicit(ColumnMetadata col, ImplicitColumnMarker marker) {
            SchemaUtils.mergeColProperties(this.col, col);
            this.col = col;
            this.markImplicit(marker);
        }

        public void markImplicit(ImplicitColumnMarker marker) {
            this.marker = marker;
        }

        public ColumnMetadata column() {
            return this.col;
        }

        public boolean isImplicit() {
            return this.marker != null;
        }

        public void setIndex(int index) {
            this.marker.setIndex(index);
        }

        public String toString() {
            return this.col.toString();
        }
    }
}

