/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.impl.scan.v3.schema.MutableTupleSchema;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.physical.resultSet.impl.ProjectionFilter;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DynamicColumn;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public abstract class DynamicSchemaFilter
implements ProjectionFilter {
    protected final CustomErrorContext errorContext;
    protected final String source;
    protected final NewColumnsMode newColumnsMode;

    public DynamicSchemaFilter(CustomErrorContext errorContext, String source, NewColumnsMode newColumnsMode) {
        this.errorContext = errorContext;
        this.source = source;
        this.newColumnsMode = newColumnsMode;
    }

    public ProjectionFilter.ProjResult buildProjection(ColumnMetadata schemaCol, ColumnMetadata probeCol) {
        if (schemaCol == null) {
            return this.newColumnProjection();
        }
        if (schemaCol instanceof ProjectedColumn) {
            return this.fromProjection((ProjectedColumn)schemaCol, probeCol);
        }
        if (schemaCol instanceof DynamicColumn) {
            return PROJECTED;
        }
        return this.fromSchema(schemaCol, probeCol);
    }

    protected ProjectionFilter.ProjResult newColumnProjection() {
        return this.newColumnsMode == NewColumnsMode.ALL ? PROJECTED : NOT_PROJECTED;
    }

    private ProjectionFilter.ProjResult fromProjection(ProjectedColumn projCol, ColumnMetadata probeCol) {
        SchemaUtils.verifyCompatibility(projCol, probeCol, this.source, this.errorContext);
        if (projCol.isMap()) {
            return new ProjectionFilter.ProjResult(true, projCol, this.mapProjection(projCol));
        }
        return new ProjectionFilter.ProjResult(true, projCol, PROJECT_ALL);
    }

    protected ProjectionFilter.ProjResult fromSchema(ColumnMetadata schemaCol, ColumnMetadata probeCol) {
        SchemaUtils.verifyConsistency(schemaCol, probeCol, this.source, this.errorContext);
        if (schemaCol.isMap() || schemaCol.isDict()) {
            return new ProjectionFilter.ProjResult(true, schemaCol, this.mapProjection(schemaCol));
        }
        return new ProjectionFilter.ProjResult(true, schemaCol);
    }

    private ProjectionFilter mapProjection(ColumnMetadata map) {
        return new DynamicTupleFilter(map.tupleSchema(), this.newColumnsMode != NewColumnsMode.NONE, this.errorContext, this.source);
    }

    @Override
    public boolean isProjected(String colName) {
        return this.projection((ColumnMetadata)MetadataUtils.newDynamic((String)colName)).isProjected;
    }

    public static enum NewColumnsMode {
        NONE,
        ALL,
        CHILD_ONLY;

    }

    public static class DynamicTupleFilter
    extends DynamicSchemaFilter {
        private final TupleMetadata mapSchema;

        public DynamicTupleFilter(TupleMetadata mapSchema, boolean isOpen, CustomErrorContext errorContext, String source) {
            super(errorContext, source, DynamicTupleFilter.newColumnsMode(mapSchema, isOpen));
            this.mapSchema = mapSchema;
        }

        private static NewColumnsMode newColumnsMode(TupleMetadata projectionSet, boolean isOpen) {
            if (!isOpen) {
                return NewColumnsMode.NONE;
            }
            if (SchemaUtils.isProjectAll(projectionSet)) {
                return NewColumnsMode.ALL;
            }
            return NewColumnsMode.CHILD_ONLY;
        }

        public static ProjectionFilter filterFor(DynamicColumn col, boolean allowMapAdditions, CustomErrorContext errorContext, String source) {
            if (col.isMap()) {
                return new DynamicTupleFilter(col.tupleSchema(), allowMapAdditions, errorContext, source);
            }
            return PROJECT_ALL;
        }

        public DynamicTupleFilter(TupleMetadata projectionSet, CustomErrorContext errorContext) {
            this(projectionSet, true, errorContext, "Reader");
        }

        @Override
        public ProjectionFilter.ProjResult projection(ColumnMetadata col) {
            return this.buildProjection(this.mapSchema.metadata(col.name()), col);
        }

        @Override
        public boolean isEmpty() {
            return this.mapSchema.isEmpty();
        }
    }

    public static class RowSchemaFilter
    extends DynamicSchemaFilter {
        private final MutableTupleSchema schema;

        public RowSchemaFilter(MutableTupleSchema schema, boolean allowMapChanges, CustomErrorContext errorContext) {
            super(errorContext, "Reader", RowSchemaFilter.newColumnsMode(schema, allowMapChanges));
            this.schema = schema;
        }

        private static NewColumnsMode newColumnsMode(MutableTupleSchema schema, boolean allowMapChanges) {
            if (schema.projectionType() == ScanSchemaTracker.ProjectionType.ALL) {
                return NewColumnsMode.ALL;
            }
            if (allowMapChanges) {
                return NewColumnsMode.CHILD_ONLY;
            }
            return NewColumnsMode.NONE;
        }

        @Override
        public ProjectionFilter.ProjResult projection(ColumnMetadata col) {
            MutableTupleSchema.ColumnHandle handle = this.schema.find(col.name());
            if (SchemaUtils.isExcludedFromWildcard(col) && handle == null) {
                return NOT_PROJECTED;
            }
            if (handle == null) {
                return this.newColumnProjection();
            }
            if (handle.isImplicit()) {
                logger.warn("Ignoring reader column with the same name as an implicit column: {}", (Object)col.name());
                return NOT_PROJECTED;
            }
            return this.buildProjection(handle.column(), col);
        }

        @Override
        public boolean isEmpty() {
            return this.schema.projectionType() == ScanSchemaTracker.ProjectionType.NONE;
        }
    }
}

