/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.schema;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.physical.impl.scan.v3.schema.MutableTupleSchema;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaResolver;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;

public abstract class AbstractSchemaTracker
implements ScanSchemaTracker {
    protected final CustomErrorContext errorContext;
    protected final MutableTupleSchema schema = new MutableTupleSchema();
    protected boolean isResolved;
    private TupleMetadata outputSchema;
    private int outputSchemaVersion;

    public AbstractSchemaTracker(CustomErrorContext errorContext) {
        this.errorContext = errorContext;
    }

    protected static void validateProjection(TupleMetadata projection, TupleMetadata schema) {
        if (projection == null || SchemaUtils.isProjectAll(projection)) {
            return;
        }
        if (schema.size() != projection.size()) {
            throw new IllegalArgumentException("Defined schema and projection list do not match");
        }
        for (ColumnMetadata reqCol : projection) {
            ColumnMetadata schemaCol = schema.metadata(reqCol.name());
            if (schemaCol == null) {
                throw new IllegalArgumentException(String.format("Defined schema and projection list do not match. `%s` in project list, but not in defined schema", reqCol.name()));
            }
            if (!schemaCol.isMap()) continue;
            AbstractSchemaTracker.validateProjection(reqCol.tupleSchema(), schemaCol.tupleSchema());
        }
    }

    @Override
    public ScanSchemaTracker.ProjectionType projectionType() {
        return this.schema.projectionType();
    }

    @Override
    public CustomErrorContext errorContext() {
        return this.errorContext;
    }

    @Override
    public MutableTupleSchema internalSchema() {
        return this.schema;
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    protected void checkResolved() {
        if (this.isResolved) {
            return;
        }
        switch (this.projectionType()) {
            case ALL: {
                this.isResolved = !this.schema.isEmpty() && this.schema.isResolved();
                break;
            }
            default: {
                this.isResolved = this.schema.isResolved();
            }
        }
    }

    @Override
    public TupleMetadata applyImplicitCols() {
        this.checkResolved();
        if (this.projectionType() == ScanSchemaTracker.ProjectionType.SOME && this.allColumnsAreImplicit()) {
            this.schema.setProjectionType(ScanSchemaTracker.ProjectionType.NONE);
        }
        return this.implicitColumns();
    }

    private boolean allColumnsAreImplicit() {
        for (MutableTupleSchema.ColumnHandle handle : this.schema.columns()) {
            if (handle.isImplicit()) continue;
            return false;
        }
        return true;
    }

    private TupleMetadata implicitColumns() {
        TupleSchema implicitCols = new TupleSchema();
        for (MutableTupleSchema.ColumnHandle handle : this.schema.columns()) {
            if (!handle.isImplicit()) continue;
            handle.setIndex(implicitCols.size());
            implicitCols.addColumn(handle.column());
        }
        return implicitCols;
    }

    @Override
    public TupleMetadata readerInputSchema() {
        TupleSchema readerInputSchema = new TupleSchema();
        for (MutableTupleSchema.ColumnHandle handle : this.schema.columns()) {
            if (handle.isImplicit()) continue;
            readerInputSchema.addColumn(handle.column());
        }
        return readerInputSchema;
    }

    @Override
    public TupleMetadata missingColumns(TupleMetadata readerOutputSchema) {
        TupleSchema missingCols = new TupleSchema();
        for (MutableTupleSchema.ColumnHandle handle : this.schema.columns()) {
            ColumnMetadata diff;
            if (handle.isImplicit()) continue;
            ColumnMetadata readerCol = readerOutputSchema.metadata(handle.column().name());
            if (readerCol == null) {
                missingCols.addColumn(handle.column());
                continue;
            }
            if (!readerCol.isMap() || (diff = MetadataUtils.diffMap(handle.column(), readerCol)) == null) continue;
            missingCols.addColumn(diff);
        }
        return missingCols;
    }

    @Override
    public void resolveMissingCols(TupleMetadata missingCols) {
        new ScanSchemaResolver(this.schema, ScanSchemaResolver.SchemaType.MISSING_COLS, false, this.errorContext).applySchema(missingCols);
        this.checkResolved();
    }

    @Override
    public TupleMetadata outputSchema() {
        if (this.outputSchema == null || this.outputSchemaVersion < this.schema.version()) {
            this.outputSchema = this.buildOutputSchema();
        }
        return this.outputSchema;
    }

    private TupleMetadata buildOutputSchema() {
        TupleSchema outputSchema = new TupleSchema();
        for (MutableTupleSchema.ColumnHandle handle : this.schema.columns()) {
            outputSchema.addColumn(handle.column());
        }
        return outputSchema;
    }
}

