/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public abstract class StaticBatchBuilder {
    protected final TupleMetadata schema;
    protected final ResultSetLoader loader;

    public StaticBatchBuilder(ResultVectorCache vectorCache, TupleMetadata schema) {
        this.schema = schema;
        ResultSetLoaderImpl.ResultSetOptions options = new ResultSetOptionBuilder().vectorCache(vectorCache).readerSchema(schema).build();
        this.loader = new ResultSetLoaderImpl(vectorCache.allocator(), options);
    }

    public TupleMetadata schema() {
        return this.schema;
    }

    public VectorContainer load(int rowCount) {
        this.loader.startBatch();
        this.loadBatch(rowCount);
        return this.loader.harvest();
    }

    protected abstract void loadBatch(int var1);

    public void close() {
        this.loader.close();
    }

    public VectorContainer outputContainer() {
        return this.loader.outputContainer();
    }

    public static class RepeatedBatchBuilder
    extends StaticBatchBuilder {
        private final ScalarWriter[] writers;
        private final Object[] values;

        public RepeatedBatchBuilder(ResultVectorCache vectorCache, TupleMetadata schema, Object[] values) {
            super(vectorCache, schema);
            this.values = values;
            RowSetLoader writer = this.loader.writer();
            this.writers = new ScalarWriter[schema.size()];
            for (int i = 0; i < this.writers.length; ++i) {
                this.writers[i] = writer.scalar(i);
            }
        }

        @Override
        protected void loadBatch(int rowCount) {
            RowSetLoader writer = this.loader.writer();
            int n = Math.min(this.values.length, this.schema.size());
            for (int i = 0; i < rowCount; ++i) {
                writer.start();
                for (int j = 0; j < n; ++j) {
                    if (this.values[j] == null) continue;
                    this.writers[j].setValue(this.values[j]);
                }
                writer.save();
            }
        }
    }

    public static class NullBatchBuilder
    extends StaticBatchBuilder {
        public NullBatchBuilder(ResultVectorCache vectorCache, TupleMetadata schema) {
            super(vectorCache, schema);
        }

        @Override
        protected void loadBatch(int rowCount) {
            this.loader.skipRows(rowCount);
        }
    }
}

