/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ReaderLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.StaticBatchBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class SchemaNegotiatorImpl
implements SchemaNegotiator {
    protected final ReaderLifecycle readerLifecycle;
    protected TupleMetadata readerSchema;
    protected boolean isSchemaComplete;
    protected int batchSize = 65536;
    protected CustomErrorContext baseErrorContext;
    protected CustomErrorContext readerErrorContext;

    public SchemaNegotiatorImpl(ReaderLifecycle readerLifecycle) {
        this.readerLifecycle = readerLifecycle;
        this.baseErrorContext = readerLifecycle.scanLifecycle().errorContext();
    }

    @Override
    public boolean isProjectionEmpty() {
        return this.readerLifecycle.schemaTracker().projectionType() == ScanSchemaTracker.ProjectionType.NONE;
    }

    @Override
    public ProjectedColumn projectionFor(String colName) {
        return this.readerLifecycle.scanLifecycle().schemaTracker().columnProjection(colName);
    }

    @Override
    public TupleMetadata providedSchema() {
        return this.readerLifecycle.scanOptions().providedSchema();
    }

    @Override
    public TupleMetadata inputSchema() {
        return this.readerLifecycle.readerInputSchema();
    }

    @Override
    public OperatorContext context() {
        return this.readerLifecycle.scanLifecycle().context();
    }

    @Override
    public CustomErrorContext parentErrorContext() {
        return this.baseErrorContext;
    }

    @Override
    public CustomErrorContext errorContext() {
        return this.readerErrorContext == null ? this.baseErrorContext : this.readerErrorContext;
    }

    @Override
    public void setErrorContext(CustomErrorContext errorContext) {
        this.readerErrorContext = errorContext;
    }

    @Override
    public void tableSchema(TupleMetadata schema, boolean isComplete) {
        this.readerSchema = schema;
        this.isSchemaComplete = schema != null && isComplete;
    }

    @Override
    public void tableSchema(TupleMetadata schema) {
        this.readerSchema = schema;
    }

    @Override
    public void schemaIsComplete(boolean isComplete) {
        this.isSchemaComplete = isComplete;
    }

    public boolean isSchemaComplete() {
        return this.readerSchema != null && this.isSchemaComplete;
    }

    @Override
    public void batchSize(int maxRecordsPerBatch) {
        this.batchSize = maxRecordsPerBatch;
    }

    @Override
    public String userName() {
        return this.readerLifecycle.scanOptions().userName();
    }

    @Override
    public ResultSetLoader build() {
        return this.readerLifecycle.buildLoader();
    }

    public StaticBatchBuilder implicitColumnsLoader() {
        return null;
    }

    public ManagedReader newReader(ReaderFactory<?> readerFactory) throws ManagedReader.EarlyEofException {
        return readerFactory.next(this);
    }

    protected void onEndBatch() {
    }
}

