/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.v3.ReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.ScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ReaderLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaConfigBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.resultSet.impl.ResultVectorCacheImpl;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class ScanLifecycle {
    private final OperatorContext context;
    private final ScanLifecycleBuilder options;
    private final ScanSchemaTracker schemaTracker;
    private final ReaderFactory<?> readerFactory;
    private int batchCount;
    private long rowCount;
    private final ResultVectorCacheImpl vectorCache;

    public ScanLifecycle(OperatorContext context, ScanLifecycleBuilder builder) {
        this.context = context;
        this.options = builder;
        this.schemaTracker = new ScanSchemaConfigBuilder().projection(builder.projection()).definedSchema(builder.definedSchema()).providedSchema(builder.providedSchema()).allowSchemaChange(builder.allowSchemaChange()).build();
        if (builder.schemaValidator() != null) {
            builder.schemaValidator().validate(this.schemaTracker);
        }
        this.vectorCache = new ResultVectorCacheImpl(this.allocator(), false);
        this.readerFactory = builder.readerFactory();
    }

    public OperatorContext context() {
        return this.context;
    }

    public ScanLifecycleBuilder options() {
        return this.options;
    }

    public ScanSchemaTracker schemaTracker() {
        return this.schemaTracker;
    }

    public ResultVectorCacheImpl vectorCache() {
        return this.vectorCache;
    }

    public ReaderFactory<?> readerFactory() {
        return this.readerFactory;
    }

    public boolean hasOutputSchema() {
        return this.schemaTracker.isResolved();
    }

    public CustomErrorContext errorContext() {
        return this.options.errorContext();
    }

    public BufferAllocator allocator() {
        return this.context.getAllocator();
    }

    public int batchCount() {
        return this.batchCount;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public void tallyBatch(int rowCount) {
        ++this.batchCount;
        this.rowCount += (long)rowCount;
    }

    public RowBatchReader nextReader() {
        if (this.batchCount > 0 && this.rowCount >= this.options.limit()) {
            return null;
        }
        if (!this.readerFactory.hasNext()) {
            return null;
        }
        return new ReaderLifecycle(this, this.options.limit() - this.rowCount);
    }

    protected SchemaNegotiatorImpl newNegotiator(ReaderLifecycle readerLifecycle) {
        return new SchemaNegotiatorImpl(readerLifecycle);
    }

    public TupleMetadata outputSchema() {
        return this.schemaTracker.outputSchema();
    }

    public void close() {
    }
}

