/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import java.util.ArrayList;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.ScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.MissingColumnHandlerBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.OutputBatchBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ScanLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.StaticBatchBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderLifecycle
implements RowBatchReader {
    private static final Logger logger = LoggerFactory.getLogger(ReaderLifecycle.class);
    private final ScanLifecycle scanLifecycle;
    private final long limit;
    protected final TupleMetadata readerInputSchema;
    private ManagedReader reader;
    private final SchemaNegotiatorImpl schemaNegotiator;
    protected ResultSetLoader tableLoader;
    private int prevTableSchemaVersion;
    private StaticBatchBuilder implicitColumnsLoader;
    private StaticBatchBuilder missingColumnsHandler;
    private OutputBatchBuilder outputBuilder;
    private State state = State.START;

    public ReaderLifecycle(ScanLifecycle scanLifecycle, long limit) {
        this.scanLifecycle = scanLifecycle;
        this.limit = limit;
        this.readerInputSchema = this.schemaTracker().readerInputSchema();
        this.schemaNegotiator = scanLifecycle.newNegotiator(this);
    }

    public ScanLifecycle scanLifecycle() {
        return this.scanLifecycle;
    }

    public TupleMetadata readerInputSchema() {
        return this.readerInputSchema;
    }

    public CustomErrorContext errorContext() {
        return this.schemaNegotiator.errorContext();
    }

    public ScanSchemaTracker schemaTracker() {
        return this.scanLifecycle.schemaTracker();
    }

    public ScanLifecycleBuilder scanOptions() {
        return this.scanLifecycle.options();
    }

    @Override
    public String name() {
        if (this.reader == null) {
            return this.getClass().getSimpleName();
        }
        return this.reader.getClass().getSimpleName();
    }

    public ResultSetLoader tableLoader() {
        return this.tableLoader;
    }

    @Override
    public boolean open() {
        try {
            this.reader = this.schemaNegotiator.newReader(this.scanLifecycle.readerFactory());
        }
        catch (ManagedReader.EarlyEofException e) {
            logger.info("Reader has no data or schema, skipped. Factory: {}", (Object)this.scanLifecycle.readerFactory().getClass().getSimpleName());
            this.reader = null;
            return false;
        }
        catch (UserException e) {
            throw e;
        }
        catch (Exception e) {
            throw UserException.dataReadError(e).addContext("Failed to open reader").addContext(this.errorContext()).build(logger);
        }
        if (this.tableLoader == null) {
            throw UserException.internalError().message("Reader returned true from open, but did not call SchemaNegotiator.build().", new Object[0]).addContext("Reader", this.reader.getClass().getSimpleName()).addContext(this.errorContext()).build(logger);
        }
        return true;
    }

    public ResultSetLoader buildLoader() {
        Preconditions.checkState(this.state == State.START);
        ScanLifecycleBuilder scanOptions = this.scanOptions();
        ResultSetOptionBuilder options = new ResultSetOptionBuilder().rowCountLimit(Math.min(this.schemaNegotiator.batchSize, scanOptions.scanBatchRecordLimit())).vectorCache(this.scanLifecycle.vectorCache()).batchSizeLimit(scanOptions.scanBatchByteLimit()).errorContext(this.errorContext()).projectionFilter(this.schemaTracker().projectionFilter(this.errorContext())).readerSchema(this.schemaNegotiator.readerSchema).limit(this.limit);
        this.applyEarlySchema();
        this.tableLoader = new ResultSetLoaderImpl(this.scanLifecycle.allocator(), options.build());
        this.state = State.DATA;
        return this.tableLoader;
    }

    private void applyEarlySchema() {
        if (this.schemaNegotiator.isSchemaComplete()) {
            this.schemaTracker().applyEarlyReaderSchema(this.schemaNegotiator.readerSchema);
            TupleMetadata missingCols = this.missingColumnsBuilder(this.schemaNegotiator.readerSchema).buildSchema();
            if (missingCols != null) {
                this.schemaTracker().resolveMissingCols(missingCols);
            }
        }
    }

    @Override
    public boolean defineSchema() {
        boolean hasSchema;
        boolean bl = hasSchema = this.schemaNegotiator.isSchemaComplete() && this.schemaTracker().isResolved();
        if (hasSchema) {
            this.tableLoader.startBatch();
            this.endBatch();
        }
        return hasSchema;
    }

    @Override
    public boolean next() {
        switch (this.state) {
            case EOF: {
                return false;
            }
            case LIMIT: {
                this.outputBuilder = null;
                this.state = State.EOF;
                return false;
            }
        }
        this.tableLoader.startBatch();
        if (this.state == State.DATA) {
            try {
                if (!this.reader.next()) {
                    this.state = State.FINAL;
                } else if (this.tableLoader.atLimit()) {
                    this.state = State.LIMIT;
                }
            }
            catch (UserException e) {
                throw e;
            }
            catch (Exception e) {
                throw UserException.dataReadError(e).addContext("File read failed").addContext(this.errorContext()).build(logger);
            }
        }
        this.endBatch();
        return this.state != State.EOF;
    }

    private void endBatch() {
        this.schemaNegotiator.onEndBatch();
        VectorContainer readerOutput = this.tableLoader.harvest();
        if (readerOutput.getRecordCount() == 0 && !this.returnEmptyBatch(readerOutput)) {
            readerOutput.clear();
            this.outputBuilder = null;
            this.state = State.EOF;
            return;
        }
        if (this.tableLoader.batchCount() == 1 || this.prevTableSchemaVersion < this.tableLoader.schemaVersion()) {
            this.reviseOutputProjection(this.tableLoader.outputSchema());
        }
        int rowCount = this.buildOutputBatch(readerOutput);
        this.scanLifecycle.tallyBatch(rowCount);
    }

    private boolean returnEmptyBatch(VectorContainer readerOutput) {
        if (this.scanLifecycle.batchCount() > 0) {
            return false;
        }
        if (this.tableLoader.schemaVersion() == 0) {
            return this.schemaTracker().isResolved();
        }
        return true;
    }

    private void reviseOutputProjection(TupleMetadata readerOutputSchema) {
        this.schemaTracker().applyReaderSchema(readerOutputSchema, this.schemaNegotiator.errorContext());
        this.missingColumnsHandler = this.missingColumnsBuilder(readerOutputSchema).build();
        if (this.missingColumnsHandler != null) {
            this.schemaTracker().resolveMissingCols(this.missingColumnsHandler.schema());
        }
        this.outputBuilder = null;
        this.prevTableSchemaVersion = this.tableLoader.schemaVersion();
    }

    public MissingColumnHandlerBuilder missingColumnsBuilder(TupleMetadata readerSchema) {
        return new MissingColumnHandlerBuilder().allowRequiredNullColumns(this.scanOptions().allowRequiredNullColumns()).inputSchema(this.schemaTracker().missingColumns(readerSchema)).vectorCache(this.scanLifecycle.vectorCache()).nullType(this.scanOptions().nullType());
    }

    private int buildOutputBatch(VectorContainer readerContainer) {
        if (this.tableLoader.batchCount() == 1) {
            this.implicitColumnsLoader = this.schemaNegotiator.implicitColumnsLoader();
        }
        int rowCount = readerContainer.getRecordCount();
        if (this.implicitColumnsLoader != null) {
            this.implicitColumnsLoader.load(rowCount);
        }
        if (this.missingColumnsHandler != null) {
            this.missingColumnsHandler.load(rowCount);
        }
        if (this.outputBuilder == null) {
            this.createOutputBuilder();
        }
        this.outputBuilder.load(rowCount);
        return rowCount;
    }

    private void createOutputBuilder() {
        ArrayList<OutputBatchBuilder.BatchSource> sources = new ArrayList<OutputBatchBuilder.BatchSource>();
        sources.add(new OutputBatchBuilder.BatchSource(this.tableLoader.outputSchema(), this.tableLoader.outputContainer()));
        if (this.implicitColumnsLoader != null) {
            sources.add(new OutputBatchBuilder.BatchSource(this.implicitColumnsLoader.schema(), this.implicitColumnsLoader.outputContainer()));
        }
        if (this.missingColumnsHandler != null) {
            sources.add(new OutputBatchBuilder.BatchSource(this.missingColumnsHandler.schema(), this.missingColumnsHandler.outputContainer()));
        }
        this.outputBuilder = new OutputBatchBuilder(this.schemaTracker().outputSchema(), sources, this.scanLifecycle.allocator());
    }

    public TupleMetadata readerOutputSchema() {
        return this.tableLoader == null ? null : this.tableLoader.outputSchema();
    }

    @Override
    public VectorContainer output() {
        return this.outputBuilder == null ? null : this.outputBuilder.outputContainer();
    }

    @Override
    public int schemaVersion() {
        return this.schemaTracker().schemaVersion();
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (UserException e) {
            throw e;
        }
        catch (Exception e) {
            throw UserException.dataReadError(e).addContext("Reader close failed").addContext(this.errorContext()).build(logger);
        }
        finally {
            this.reader = null;
            if (this.tableLoader != null) {
                this.tableLoader.close();
                this.tableLoader = null;
            }
        }
    }

    private static enum State {
        START,
        DATA,
        FINAL,
        LIMIT,
        EOF;

    }
}

