/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class OutputBatchBuilder {
    private final TupleMetadata outputSchema;
    private final List<BatchSource> sources;
    private final Object[] vectorSources;
    private final VectorContainer outputContainer;
    private final List<MapVector> mapVectors = new ArrayList<MapVector>();

    public OutputBatchBuilder(TupleMetadata outputSchema, List<BatchSource> sources, BufferAllocator allocator) {
        this.outputSchema = outputSchema;
        this.sources = sources;
        this.outputContainer = new VectorContainer(allocator);
        this.vectorSources = new Object[outputSchema.size()];
        for (int i = 0; i < sources.size(); ++i) {
            this.defineSourceBatchMapping(sources.get(i).schema, i);
        }
        this.physicalProjection();
    }

    protected void defineSourceBatchMapping(TupleMetadata schema, int source) {
        for (int i = 0; i < schema.size(); ++i) {
            ColumnMetadata col = schema.metadata(i);
            int outputIndex = this.outputSchema.index(col.name());
            Preconditions.checkState(outputIndex >= 0);
            VectorSource vectorSource = new VectorSource(source, i);
            if (col.isMap() && !col.isArray()) {
                if (this.vectorSources[outputIndex] == null) {
                    this.vectorSources[outputIndex] = new ArrayList();
                }
                ((List)this.vectorSources[outputIndex]).add(vectorSource);
                continue;
            }
            assert (this.vectorSources[outputIndex] == null);
            this.vectorSources[outputIndex] = vectorSource;
        }
    }

    private void physicalProjection() {
        this.outputContainer.removeAll();
        this.mapVectors.clear();
        for (int i = 0; i < this.outputSchema.size(); ++i) {
            ColumnMetadata outputCol = this.outputSchema.metadata(i);
            ValueVector outputVector = outputCol.isMap() && !outputCol.isArray() ? this.buildTopMap(outputCol, (List)this.vectorSources[i]) : this.getVector((VectorSource)this.vectorSources[i]);
            this.outputContainer.add(outputVector);
        }
        this.outputContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
    }

    private ValueVector buildTopMap(ColumnMetadata outputCol, List<VectorSource> vectorSources) {
        ArrayList<MapSource> sourceMaps = new ArrayList<MapSource>();
        for (VectorSource source : vectorSources) {
            sourceMaps.add(new MapSource(this.sources.get(source.source).schema.metadata(source.offset).tupleSchema(), (AbstractMapVector)this.getVector(source)));
        }
        MapBuilder builder = new MapBuilder(outputCol, sourceMaps);
        AbstractMapVector vector = builder.build(this.outputContainer.getAllocator());
        this.mapVectors.addAll(builder.mapVectors);
        return vector;
    }

    public ValueVector getVector(VectorSource source) {
        return this.sources.get(source.source).container.getValueVector(source.offset).getValueVector();
    }

    public void load(int rowCount) {
        this.outputContainer.setRecordCount(rowCount);
        for (MapVector v : this.mapVectors) {
            v.setMapValueCount(rowCount);
        }
    }

    public VectorContainer outputContainer() {
        return this.outputContainer;
    }

    public void close() {
        this.outputContainer.removeAll();
    }

    public static class BatchSource {
        private final TupleMetadata schema;
        private final VectorContainer container;

        public BatchSource(TupleMetadata schema, VectorContainer container) {
            this.schema = schema;
            this.container = container;
        }
    }

    private static class VectorSource {
        protected final int source;
        protected final int offset;

        public VectorSource(int source, int offset) {
            this.source = source;
            this.offset = offset;
        }

        public String toString() {
            return "[source=" + this.source + ", offset=" + this.offset + "]";
        }
    }

    public static class MapSource {
        protected final TupleMetadata mapSchema;
        protected final AbstractMapVector mapVector;

        public MapSource(TupleMetadata mapSchema, AbstractMapVector mapVector) {
            this.mapSchema = mapSchema;
            this.mapVector = mapVector;
        }
    }

    private static class MapBuilder {
        private final ColumnMetadata outputCol;
        private final TupleMetadata mapSchema;
        private final List<MapSource> sourceMaps;
        private final Object[] memberSources;
        private final List<MapVector> mapVectors = new ArrayList<MapVector>();

        private MapBuilder(ColumnMetadata outputCol, List<MapSource> sourceMaps) {
            this.outputCol = outputCol;
            this.mapSchema = outputCol.tupleSchema();
            this.sourceMaps = sourceMaps;
            this.memberSources = new Object[this.mapSchema.size()];
            for (int i = 0; i < sourceMaps.size(); ++i) {
                this.defineSourceMapMapping(sourceMaps.get((int)i).mapSchema, i);
            }
        }

        private void defineSourceMapMapping(TupleMetadata sourceSchema, int source) {
            for (int i = 0; i < sourceSchema.size(); ++i) {
                ColumnMetadata col = sourceSchema.metadata(i);
                int outputIndex = this.mapSchema.index(col.name());
                Preconditions.checkState(outputIndex >= 0);
                VectorSource vectorSource = new VectorSource(source, i);
                if (col.isMap()) {
                    if (this.memberSources[outputIndex] == null) {
                        this.memberSources[outputIndex] = new ArrayList();
                    }
                    ((List)this.memberSources[outputIndex]).add(vectorSource);
                    continue;
                }
                assert (this.memberSources[outputIndex] == null);
                this.memberSources[outputIndex] = vectorSource;
            }
        }

        public AbstractMapVector build(BufferAllocator allocator) {
            AbstractMapVector mapVector = (AbstractMapVector)BasicTypeHelper.getNewVector(this.outputCol.name(), allocator, this.outputCol.majorType(), null);
            for (int i = 0; i < this.mapSchema.size(); ++i) {
                ColumnMetadata outputCol = this.mapSchema.metadata(i);
                ValueVector outputVector = outputCol.isMap() ? this.buildNestedMap(allocator, outputCol, (List)this.memberSources[i]) : this.getMember((VectorSource)this.memberSources[i]);
                mapVector.putChild(outputCol.name(), outputVector);
            }
            if (mapVector instanceof MapVector) {
                this.mapVectors.add((MapVector)mapVector);
            }
            return mapVector;
        }

        private ValueVector buildNestedMap(BufferAllocator allocator, ColumnMetadata outputCol, List<VectorSource> vectorSources) {
            ArrayList<MapSource> childMaps = new ArrayList<MapSource>();
            for (VectorSource source : vectorSources) {
                childMaps.add(new MapSource(this.sourceMaps.get((int)source.source).mapSchema.metadata(source.offset).tupleSchema(), (AbstractMapVector)this.getMember(source)));
            }
            MapBuilder builder = new MapBuilder(outputCol, childMaps);
            AbstractMapVector vector = builder.build(allocator);
            this.mapVectors.addAll(builder.mapVectors);
            return vector;
        }

        public ValueVector getMember(VectorSource source) {
            MapSource sourceMap = this.sourceMaps.get(source.source);
            ColumnMetadata sourceCol = sourceMap.mapSchema.metadata(source.offset);
            return sourceMap.mapVector.getChild(sourceCol.name());
        }
    }
}

