/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import java.util.List;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnMarker;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnResolver;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.StaticBatchBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.hadoop.fs.Path;

public class ImplicitFileColumnsHandler {
    private final DrillFileSystem dfs;
    private final ImplicitColumnResolver parser;
    private final ResultVectorCache vectorCache;
    private final Path rootDir;
    private final ImplicitColumnResolver.ParseResult parseResult;
    private final boolean isCompressible;

    public ImplicitFileColumnsHandler(DrillFileSystem dfs, OptionSet options, FileScanLifecycleBuilder scanOptions, ResultVectorCache vectorCache, ScanSchemaTracker schemaTracker) {
        ImplicitColumnResolver.ImplicitColumnOptions implicitOptions = new ImplicitColumnResolver.ImplicitColumnOptions().optionSet(options).dfs(dfs).maxPartitionDepth(scanOptions.maxPartitionDepth()).useLegacyWildcardExpansion(scanOptions.useLegacyWildcardExpansion());
        this.dfs = dfs;
        this.rootDir = scanOptions.rootDir();
        this.parser = new ImplicitColumnResolver(implicitOptions, scanOptions.errorContext());
        this.vectorCache = vectorCache;
        this.parseResult = this.parser.parse(schemaTracker);
        this.isCompressible = scanOptions.isCompressible();
    }

    public FileDescrip makeDescrip(FileWork fileWork) {
        FileDescrip descrip = new FileDescrip(this.dfs, fileWork, this.rootDir);
        descrip.setCompressible(this.isCompressible);
        return descrip;
    }

    public StaticBatchBuilder forFile(FileDescrip fileInfo) {
        List<ImplicitColumnMarker> columns = this.parseResult.columns();
        if (columns.isEmpty()) {
            return null;
        }
        Object[] values = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            values[i] = columns.get(i).resolve(fileInfo);
        }
        return new StaticBatchBuilder.RepeatedBatchBuilder(this.vectorCache, this.parseResult.schema(), values);
    }

    public boolean isMetadataScan() {
        return this.parseResult.isMetadataScan();
    }
}

