/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.physical.impl.scan.v3.file.ImplicitColumnMarker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.MutableTupleSchema;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ScanSchemaTracker;
import org.apache.drill.exec.physical.impl.scan.v3.schema.SchemaUtils;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplicitColumnResolver {
    private static final Logger logger = LoggerFactory.getLogger(ImplicitColumnResolver.class);
    public static final TypeProtos.MajorType IMPLICIT_COL_TYPE = Types.required(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType PARTITION_COL_TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType OPTIONAL_INTERNAL_COL_TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    private final int maxPartitionDepth;
    private final boolean useLegacyWildcardExpansion;
    private final String partitionDesignator;
    private final Pattern partitionPattern;
    private final Pattern partitionTypePattern;
    private final Map<String, ColumnExplorer.ImplicitFileColumn> colDefs = CaseInsensitiveMap.newHashMap();
    private final Map<String, ColumnExplorer.ImplicitFileColumn> typeDefs = CaseInsensitiveMap.newHashMap();
    private final CustomErrorContext errorContext;
    private final DrillFileSystem dfs;

    public ImplicitColumnResolver(ImplicitColumnOptions options, CustomErrorContext errorContext) {
        String colName;
        this.errorContext = errorContext;
        this.maxPartitionDepth = options.maxPartitionDepth;
        this.useLegacyWildcardExpansion = options.useLegacyWildcardExpansion;
        this.dfs = options.dfs;
        this.partitionDesignator = options.optionSet.getString("drill.exec.storage.file.partition.column.label");
        this.partitionPattern = Pattern.compile(this.partitionDesignator + "(\\d+)", 2);
        this.partitionTypePattern = this.partitionDesignator.equals("dir") ? this.partitionPattern : Pattern.compile("dir(\\d+)", 2);
        for (ColumnExplorer.ImplicitFileColumns implicitFileColumns : ColumnExplorer.ImplicitFileColumns.values()) {
            colName = options.optionSet.getString(implicitFileColumns.optionName());
            if (!Strings.isNullOrEmpty(colName)) {
                this.colDefs.put(colName, implicitFileColumns);
            }
            this.typeDefs.put(implicitFileColumns.propertyValue(), implicitFileColumns);
        }
        for (Enum enum_ : ColumnExplorer.ImplicitInternalFileColumns.values()) {
            colName = options.optionSet.getString(((ColumnExplorer.ImplicitInternalFileColumns)enum_).optionName());
            if (Strings.isNullOrEmpty(colName)) continue;
            this.colDefs.put(colName, (ColumnExplorer.ImplicitFileColumn)((Object)enum_));
        }
    }

    public ParseResult parse(ScanSchemaTracker tracker) {
        return new ImplicitColumnParser(this, tracker).parse();
    }

    public String partitionName(int partition) {
        return this.partitionDesignator + partition;
    }

    public static class ImplicitColumnOptions {
        protected OptionSet optionSet;
        protected int maxPartitionDepth;
        protected boolean useLegacyWildcardExpansion = true;
        protected DrillFileSystem dfs;

        public ImplicitColumnOptions optionSet(OptionSet optionSet) {
            this.optionSet = optionSet;
            return this;
        }

        public ImplicitColumnOptions maxPartitionDepth(int maxPartitionDepth) {
            this.maxPartitionDepth = maxPartitionDepth;
            return this;
        }

        public ImplicitColumnOptions useLegacyWildcardExpansion(boolean flag) {
            this.useLegacyWildcardExpansion = flag;
            return this;
        }

        public ImplicitColumnOptions dfs(DrillFileSystem dfs) {
            this.dfs = dfs;
            return this;
        }
    }

    private static class ImplicitColumnParser {
        private final ImplicitColumnResolver parser;
        private final ScanSchemaTracker tracker;
        private final MutableTupleSchema scanSchema;
        private final List<ImplicitColumnMarker> columns = new ArrayList<ImplicitColumnMarker>();
        private final Set<Integer> referencedPartitions = new HashSet<Integer>();
        private boolean isMetadataScan;

        protected ImplicitColumnParser(ImplicitColumnResolver parser, ScanSchemaTracker tracker) {
            this.parser = parser;
            this.tracker = tracker;
            this.scanSchema = tracker.internalSchema();
        }

        protected ParseResult parse() {
            for (MutableTupleSchema.ColumnHandle col : this.tracker.internalSchema().columns()) {
                this.matchColumn(col);
            }
            if (this.tracker.internalSchema().projectionType() == ScanSchemaTracker.ProjectionType.ALL) {
                this.expandWildcard();
            }
            return new ParseResult(this.columns, this.tracker.applyImplicitCols(), this.isMetadataScan);
        }

        private void expandWildcard() {
            if (!this.parser.useLegacyWildcardExpansion) {
                return;
            }
            for (int i = 0; i < this.parser.maxPartitionDepth; ++i) {
                if (this.referencedPartitions.contains(i)) continue;
                ImplicitColumnMarker.PartitionColumnMarker marker = new ImplicitColumnMarker.PartitionColumnMarker(i);
                PrimitiveColumnMetadata resolved = MetadataUtils.newScalar(this.parser.partitionName(i), PARTITION_COL_TYPE);
                this.columns.add(marker);
                this.tracker.expandImplicitCol(resolved, marker);
                this.referencedPartitions.add(i);
            }
        }

        private void matchColumn(MutableTupleSchema.ColumnHandle col) {
            String colType = SchemaUtils.implicitColType(col.column());
            if (colType != null) {
                this.resolveTaggedColumn(this.parser, col, colType);
                return;
            }
            if (col.column().isDynamic()) {
                this.matchByName(col);
            }
        }

        private void resolveTaggedColumn(ImplicitColumnResolver parser, MutableTupleSchema.ColumnHandle col, String colType) {
            Matcher m = parser.partitionTypePattern.matcher(colType);
            if (m.matches()) {
                this.resolvePartitionColumn(m, parser, col);
                return;
            }
            ColumnExplorer.ImplicitFileColumn defn = (ColumnExplorer.ImplicitFileColumn)parser.typeDefs.get(colType);
            if (defn != null) {
                this.resolveImplicitColumn((ColumnExplorer.ImplicitFileColumns)defn, col, colType);
                return;
            }
            this.resolveUnknownColumn(col, colType);
        }

        private void resolvePartitionColumn(Matcher m, ImplicitColumnResolver parser, MutableTupleSchema.ColumnHandle col) {
            ColumnMetadata colSchema = col.column();
            if (colSchema.type() != TypeProtos.MinorType.VARCHAR || colSchema.mode() != TypeProtos.DataMode.OPTIONAL) {
                throw UserException.validationError().message("Provided column `%s` is marked as a parition column, but is of the wrong type", colSchema.columnString()).addContext("Expected type", TypeProtos.MinorType.VARCHAR.name()).addContext("Expected cardinality", TypeProtos.DataMode.OPTIONAL.name()).addContext(parser.errorContext).build(logger);
            }
            int partitionIndex = Integer.parseInt(m.group(1));
            this.markImplicit(col, new ImplicitColumnMarker.PartitionColumnMarker(partitionIndex));
            this.referencedPartitions.add(partitionIndex);
        }

        private void resolveImplicitColumn(ColumnExplorer.ImplicitFileColumns defn, MutableTupleSchema.ColumnHandle col, String colType) {
            ColumnMetadata colSchema = col.column();
            if (colSchema.type() != TypeProtos.MinorType.VARCHAR || colSchema.mode() == TypeProtos.DataMode.REPEATED) {
                throw UserException.validationError().message("Provided column `%s` is marked as implicit '%s', but is of the wrong type", colSchema.columnString(), defn.propertyValue()).addContext("Expected type", TypeProtos.MinorType.VARCHAR.name()).addContext("Expected cardinality", String.format("%s or %s", TypeProtos.DataMode.REQUIRED.name(), TypeProtos.DataMode.OPTIONAL.name())).addContext(this.parser.errorContext).build(logger);
            }
            this.markImplicit(col, new ImplicitColumnMarker.FileImplicitMarker(defn));
        }

        private void markImplicit(MutableTupleSchema.ColumnHandle col, ImplicitColumnMarker marker) {
            this.columns.add(marker);
            col.markImplicit(marker);
        }

        private void resolveUnknownColumn(MutableTupleSchema.ColumnHandle col, String colType) {
            throw UserException.validationError().message("Provided column %s references an undefined implicit column type '%s'", col.column().columnString(), colType).addContext("Expected type", TypeProtos.MinorType.VARCHAR.name()).addContext("Expected cardinality", String.format("%s or %s", TypeProtos.DataMode.REQUIRED.name(), TypeProtos.DataMode.OPTIONAL.name())).addContext(this.parser.errorContext).build(logger);
        }

        private void matchByName(MutableTupleSchema.ColumnHandle col) {
            Matcher m = this.parser.partitionPattern.matcher(col.name());
            if (m.matches()) {
                this.buildPartitionColumn(m, col);
                return;
            }
            ColumnExplorer.ImplicitFileColumn defn = (ColumnExplorer.ImplicitFileColumn)this.parser.colDefs.get(col.name());
            if (defn != null) {
                this.buildImplicitColumn(defn, col);
            }
        }

        private void buildPartitionColumn(Matcher m, MutableTupleSchema.ColumnHandle col) {
            ProjectedColumn projCol = (ProjectedColumn)col.column();
            if (!projCol.isSimple()) {
                logger.warn("Projected column {} shadows partition column {}", (Object)projCol.projectString(), (Object)col.name());
                return;
            }
            int partitionIndex = Integer.parseInt(m.group(1));
            this.resolve(col, MetadataUtils.newScalar(col.name(), PARTITION_COL_TYPE), new ImplicitColumnMarker.PartitionColumnMarker(partitionIndex));
            this.referencedPartitions.add(partitionIndex);
        }

        private void resolve(MutableTupleSchema.ColumnHandle col, ColumnMetadata resolved, ImplicitColumnMarker marker) {
            this.columns.add(marker);
            this.scanSchema.resolveImplicit(col, resolved, marker);
        }

        private void buildImplicitColumn(ColumnExplorer.ImplicitFileColumn defn, MutableTupleSchema.ColumnHandle col) {
            ProjectedColumn projCol = (ProjectedColumn)col.column();
            if (!projCol.isSimple()) {
                logger.warn("Projected column {} shadows implicit column {}", (Object)projCol.projectString(), (Object)col.name());
            } else if (defn instanceof ColumnExplorer.ImplicitInternalFileColumns) {
                this.resolveInternalColumn(col, (ColumnExplorer.ImplicitInternalFileColumns)defn);
            } else {
                this.resolve(col, MetadataUtils.newScalar(col.name(), IMPLICIT_COL_TYPE), new ImplicitColumnMarker.FileImplicitMarker((ColumnExplorer.ImplicitFileColumns)defn));
            }
        }

        private void resolveInternalColumn(MutableTupleSchema.ColumnHandle col, ColumnExplorer.ImplicitInternalFileColumns defn) {
            if (defn == ColumnExplorer.ImplicitInternalFileColumns.LAST_MODIFIED_TIME && this.parser.dfs == null) {
                throw new IllegalStateException("Must provide a file system to use " + defn.name());
            }
            if (defn == ColumnExplorer.ImplicitInternalFileColumns.PROJECT_METADATA) {
                this.isMetadataScan = true;
            }
            this.resolve(col, MetadataUtils.newScalar(col.name(), defn.isOptional() ? OPTIONAL_INTERNAL_COL_TYPE : IMPLICIT_COL_TYPE), new ImplicitColumnMarker.InternalColumnMarker(defn));
        }
    }

    public static class ParseResult {
        private final List<ImplicitColumnMarker> columns;
        private final TupleMetadata schema;
        private final boolean isMetadataScan;

        protected ParseResult(List<ImplicitColumnMarker> columns, TupleMetadata schema, boolean isMetadataScan) {
            ImplicitColumnMarker[] reordered = new ImplicitColumnMarker[columns.size()];
            Iterator<ImplicitColumnMarker> iterator = columns.iterator();
            while (iterator.hasNext()) {
                ImplicitColumnMarker col;
                reordered[col.index()] = col = iterator.next();
            }
            this.columns = Arrays.asList(reordered);
            this.schema = schema;
            this.isMetadataScan = isMetadataScan;
        }

        public TupleMetadata schema() {
            return this.schema;
        }

        public List<ImplicitColumnMarker> columns() {
            return this.columns;
        }

        public boolean isMetadataScan() {
            return this.isMetadataScan;
        }

        public Object[] resolve(FileDescrip fileInfo) {
            Object[] values = new Object[this.columns.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.columns.get(i).resolve(fileInfo);
            }
            return values;
        }
    }
}

