/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.v3.ScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycle;
import org.apache.drill.exec.physical.impl.scan.v3.lifecycle.ScanLifecycle;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class FileScanLifecycleBuilder
extends ScanLifecycleBuilder {
    protected int maxPartitionDepth;
    protected boolean useLegacyWildcardExpansion = true;
    protected Path rootDir;
    private List<FileWork> splits;
    private Configuration fsConf;
    private boolean compressible;

    public void fileSystemConfig(Configuration fsConf) {
        this.fsConf = fsConf;
    }

    public void fileSplits(List<FileWork> splits) {
        this.splits = splits;
    }

    public void fileSplitImpls(List<CompleteFileWork.FileWorkImpl> splits) {
        this.splits = new ArrayList<CompleteFileWork.FileWorkImpl>(splits);
    }

    public void maxPartitionDepth(int maxPartitionDepth) {
        this.maxPartitionDepth = maxPartitionDepth;
    }

    public void useLegacyWildcardExpansion(boolean useLegacyWildcardExpansion) {
        this.useLegacyWildcardExpansion = useLegacyWildcardExpansion;
    }

    public void rootDir(Path rootDir) {
        this.rootDir = rootDir;
    }

    public void compressible(boolean compressible) {
        this.compressible = compressible;
    }

    public List<FileWork> splits() {
        return Preconditions.checkNotNull(this.splits);
    }

    public Configuration fileSystemConfig() {
        if (this.fsConf == null) {
            this.fsConf = new Configuration();
        }
        return this.fsConf;
    }

    public int maxPartitionDepth() {
        return this.maxPartitionDepth;
    }

    public boolean useLegacyWildcardExpansion() {
        return this.useLegacyWildcardExpansion;
    }

    public Path rootDir() {
        return this.rootDir;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    @Override
    public ScanLifecycle build(OperatorContext context) {
        return new FileScanLifecycle(context, this);
    }
}

