/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.v3.file;

import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;

public class FileDescrip {
    private final DrillFileSystem dfs;
    private final FileWork fileWork;
    private final FileSplit split;
    private final String[] dirPath;
    private boolean isCompressible;
    protected Integer rowGroupIndex;
    protected Long rowGroupStart;
    protected Long rowGroupLength;
    private String modTime;
    protected boolean isEmpty;

    public FileDescrip(DrillFileSystem dfs, FileWork fileWork, Path selectionRoot) {
        Path bareFilePath;
        this.dfs = dfs;
        this.fileWork = fileWork;
        Path path = dfs.makeQualified(fileWork.getPath());
        this.split = new FileSplit(path, fileWork.getStart(), fileWork.getLength(), new String[]{""});
        Path filePath = fileWork.getPath();
        if (selectionRoot == null || filePath == null) {
            this.dirPath = null;
            return;
        }
        Path rootPath = Path.getPathWithoutSchemeAndAuthority((Path)selectionRoot);
        if (rootPath.equals((Object)(bareFilePath = Path.getPathWithoutSchemeAndAuthority((Path)filePath)))) {
            this.dirPath = null;
            return;
        }
        this.dirPath = ColumnExplorer.parsePartitions(filePath, rootPath, false);
        if (this.dirPath == null) {
            throw new IllegalArgumentException(String.format("Selection root of \"%s\" is not a leading path of \"%s\"", selectionRoot.toString(), filePath.toString()));
        }
    }

    public DrillFileSystem fileSystem() {
        return this.dfs;
    }

    public Path filePath() {
        return this.fileWork.getPath();
    }

    public FileSplit split() {
        return this.split;
    }

    public FileWork fileWork() {
        return this.fileWork;
    }

    public String partition(int index) {
        if (this.dirPath == null || this.dirPath.length <= index) {
            return null;
        }
        return this.dirPath[index];
    }

    public int dirPathLength() {
        return this.dirPath == null ? 0 : this.dirPath.length;
    }

    public void setRowGroupAttribs(int index, long start, long length) {
        this.rowGroupIndex = index;
        this.rowGroupStart = start;
        this.rowGroupLength = length;
    }

    public String getModTime() {
        if (this.modTime == null) {
            try {
                this.modTime = String.valueOf(this.dfs.getFileStatus(this.filePath()).getModificationTime());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.modTime;
    }

    @VisibleForTesting
    public void setModTime(String modTime) {
        this.modTime = modTime;
    }

    public void setCompressible(boolean isCompressed) {
        this.isCompressible = isCompressed;
    }

    public boolean isCompressible() {
        return this.isCompressible;
    }

    public InputStream open() throws IOException {
        if (this.isCompressible) {
            return this.dfs.openPossiblyCompressedStream(this.filePath());
        }
        return this.dfs.open(this.filePath());
    }

    public void markEmpty() {
        this.isEmpty = true;
    }
}

