/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.exec.physical.impl.scan.project.AbstractUnresolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ReaderLevelProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTableColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanLevelProjection;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class WildcardSchemaProjection
extends ReaderLevelProjection {
    public WildcardSchemaProjection(ScanLevelProjection scanProj, TupleMetadata readerSchema, ResolvedTuple rootTuple, List<ReaderLevelProjection.ReaderProjectionResolver> resolvers) {
        super(resolvers);
        boolean[] readerProjectionMap = new boolean[readerSchema.size()];
        for (ColumnProjection col : scanProj.columns()) {
            if (col instanceof AbstractUnresolvedColumn.UnresolvedColumn) {
                AbstractUnresolvedColumn.UnresolvedColumn tableCol = (AbstractUnresolvedColumn.UnresolvedColumn)col;
                ColumnMetadata readerCol = readerSchema.metadata(tableCol.name());
                if (readerCol != null) {
                    int index = readerSchema.index(col.name());
                    readerProjectionMap[index] = true;
                    rootTuple.add(new ResolvedTableColumn(tableCol.metadata(), rootTuple, index));
                    continue;
                }
                rootTuple.add(rootTuple.nullBuilder.add(tableCol.metadata()));
                continue;
            }
            this.resolveSpecial(rootTuple, col, readerSchema);
        }
        if (scanProj.projectionType() == ScanLevelProjection.ScanProjectionType.SCHEMA_WILDCARD) {
            for (int i = 0; i < readerProjectionMap.length; ++i) {
                ColumnMetadata readerCol;
                if (readerProjectionMap[i] || (readerCol = readerSchema.metadata(i)).booleanProperty("drill.special")) continue;
                rootTuple.add(new ResolvedTableColumn(readerCol.name(), readerCol.schema(), rootTuple, i));
            }
        }
    }
}

