/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.scan.project.NullColumnBuilder;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedDictColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedMapColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedNullColumn;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.physical.resultSet.ResultVectorCache;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.RepeatedDictVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public abstract class ResolvedTuple
implements VectorSource {
    protected final List<ResolvedColumn> members = new ArrayList<ResolvedColumn>();
    protected final NullColumnBuilder nullBuilder;
    protected List<ResolvedTuple> children;
    protected VectorSource binding;

    public ResolvedTuple(NullColumnBuilder nullBuilder) {
        this.nullBuilder = nullBuilder;
    }

    public NullColumnBuilder nullBuilder() {
        return this.nullBuilder;
    }

    public void add(ResolvedColumn col) {
        this.members.add(col);
    }

    public void addChild(ResolvedTuple child) {
        if (this.children == null) {
            this.children = new ArrayList<ResolvedTuple>();
        }
        this.children.add(child);
    }

    public void removeChild(ResolvedTuple child) {
        assert (!this.children.isEmpty() && this.children.get(this.children.size() - 1) == child);
        this.children.remove(this.children.size() - 1);
    }

    public boolean isSimpleProjection() {
        if (this.children != null && !this.children.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (!(this.members.get(i) instanceof ResolvedNullColumn)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public List<ResolvedColumn> columns() {
        return this.members;
    }

    public void buildNulls(ResultVectorCache vectorCache) {
        if (this.nullBuilder != null) {
            this.nullBuilder.build(vectorCache);
        }
        if (this.children != null) {
            for (ResolvedTuple child : this.children) {
                child.buildNulls(vectorCache.childCache(child.name()));
            }
        }
    }

    public void loadNulls(int rowCount) {
        if (this.nullBuilder != null) {
            this.nullBuilder.load(rowCount);
        }
        if (this.children != null) {
            for (ResolvedTuple child : this.children) {
                child.loadNulls(this.innerCardinality(rowCount));
            }
        }
    }

    public abstract int innerCardinality(int var1);

    protected void buildColumns() {
        for (int i = 0; i < this.members.size(); ++i) {
            this.members.get(i).project(this);
        }
    }

    public abstract void addVector(ValueVector var1);

    public abstract void setRowCount(int var1);

    protected void cascadeRowCount(int rowCount) {
        if (this.children == null) {
            return;
        }
        for (ResolvedTuple child : this.children) {
            child.setRowCount(rowCount);
        }
    }

    public abstract BufferAllocator allocator();

    public abstract String name();

    public void reset() {
        this.members.clear();
        this.children = null;
    }

    public void close() {
        if (this.nullBuilder != null) {
            this.nullBuilder.close();
        }
        if (this.children != null) {
            for (ResolvedTuple child : this.children) {
                child.close();
            }
        }
    }

    public static class ResolvedDictArray
    extends ResolvedDict {
        protected RepeatedDictVector inputVector;
        protected RepeatedDictVector outputVector;
        private int valueCount;

        public ResolvedDictArray(ResolvedDictColumn parentColumn) {
            super(parentColumn);
        }

        @Override
        public void addVector(ValueVector vector) {
            ((DictVector)this.outputVector.getDataVector()).putChild(vector.getField().getName(), vector);
        }

        @Override
        public ValueVector vector(int index) {
            assert (this.inputVector != null);
            return ((DictVector)this.inputVector.getDataVector()).getChildByOrdinal(index);
        }

        @Override
        public RepeatedDictVector buildVector() {
            if (this.parentColumn.sourceIndex() != -1) {
                ResolvedTuple parentTuple = this.parentColumn.parent();
                this.inputVector = (RepeatedDictVector)parentTuple.vector(this.parentColumn.sourceIndex());
            }
            MaterializedField colSchema = this.parentColumn.schema();
            MaterializedField dictField = MaterializedField.create(colSchema.getName(), colSchema.getType());
            this.outputVector = new RepeatedDictVector(dictField, this.parentColumn.parent().allocator(), null);
            this.valueCount = this.inputVector.getOffsetVector().getAccessor().getValueCount();
            this.buildColumns();
            return this.outputVector;
        }

        @Override
        public BufferAllocator allocator() {
            return this.outputVector.getAllocator();
        }

        @Override
        public String name() {
            return this.parentColumn.name();
        }

        @Override
        public void setRowCount(int rowCount) {
            this.cascadeRowCount(this.valueCount);
        }

        @Override
        public int innerCardinality(int outerCardinality) {
            return this.valueCount;
        }
    }

    public static class ResolvedSingleDict
    extends ResolvedDict {
        protected DictVector inputVector;
        protected DictVector outputVector;

        public ResolvedSingleDict(ResolvedDictColumn parentColumn) {
            super(parentColumn);
        }

        @Override
        public void addVector(ValueVector vector) {
            this.outputVector.putChild(vector.getField().getName(), vector);
        }

        @Override
        public ValueVector vector(int index) {
            assert (this.inputVector != null);
            return this.inputVector.getChildByOrdinal(index);
        }

        @Override
        public ValueVector buildVector() {
            ValueVector vector;
            if (this.parentColumn.sourceIndex() != -1 && (vector = this.parentColumn.parent().vector(this.parentColumn.sourceIndex())) instanceof DictVector) {
                this.inputVector = (DictVector)vector;
            }
            MaterializedField colSchema = this.parentColumn.schema();
            MaterializedField dictField = MaterializedField.create(colSchema.getName(), colSchema.getType());
            this.outputVector = new DictVector(dictField, this.parentColumn.parent().allocator(), null);
            this.buildColumns();
            return this.outputVector;
        }

        @Override
        public BufferAllocator allocator() {
            return this.outputVector.getAllocator();
        }

        @Override
        public String name() {
            return this.parentColumn.name();
        }

        @Override
        public void setRowCount(int rowCount) {
            this.outputVector.getMutator().setValueCount(rowCount);
            this.cascadeRowCount(rowCount);
        }

        @Override
        public int innerCardinality(int outerCardinality) {
            return outerCardinality;
        }
    }

    public static abstract class ResolvedDict
    extends ResolvedTuple {
        protected final ResolvedDictColumn parentColumn;

        public ResolvedDict(ResolvedDictColumn parentColumn) {
            super(parentColumn.parent().nullBuilder == null ? null : parentColumn.parent().nullBuilder.newChild(parentColumn.name()));
            this.parentColumn = parentColumn;
        }

        public abstract ValueVector buildVector();

        @Override
        public String name() {
            return this.parentColumn.name();
        }
    }

    public static class ResolvedMapArray
    extends ResolvedMap {
        private int valueCount;

        public ResolvedMapArray(ResolvedMapColumn parentColumn) {
            super(parentColumn);
        }

        @Override
        protected AbstractMapVector createMap(AbstractMapVector inputMap, MaterializedField schema, BufferAllocator allocator) {
            RepeatedMapVector source = (RepeatedMapVector)inputMap;
            UInt4Vector offsets = source.getOffsetVector();
            this.valueCount = offsets.getAccessor().getValueCount();
            return new RepeatedMapVector(schema, offsets, null);
        }

        @Override
        public int innerCardinality(int outerCardinality) {
            return this.valueCount;
        }

        @Override
        public void setRowCount(int rowCount) {
            this.cascadeRowCount(this.valueCount);
        }
    }

    public static class ResolvedSingleMap
    extends ResolvedMap {
        public ResolvedSingleMap(ResolvedMapColumn parentColumn) {
            super(parentColumn);
        }

        @Override
        protected AbstractMapVector createMap(AbstractMapVector inputMap, MaterializedField schema, BufferAllocator allocator) {
            return new MapVector(schema, allocator, null);
        }

        @Override
        public void setRowCount(int rowCount) {
            ((MapVector)this.outputMap).setMapValueCount(rowCount);
            this.cascadeRowCount(rowCount);
        }

        @Override
        public int innerCardinality(int outerCardinality) {
            return outerCardinality;
        }
    }

    public static abstract class ResolvedMap
    extends ResolvedTuple {
        protected final ResolvedMapColumn parentColumn;
        protected AbstractMapVector inputMap;
        protected AbstractMapVector outputMap;

        public ResolvedMap(ResolvedMapColumn parentColumn) {
            super(parentColumn.parent().nullBuilder == null ? null : parentColumn.parent().nullBuilder.newChild(parentColumn.name()));
            this.parentColumn = parentColumn;
        }

        @Override
        public void addVector(ValueVector vector) {
            this.outputMap.putChild(vector.getField().getName(), vector);
        }

        @Override
        public ValueVector vector(int index) {
            assert (this.inputMap != null);
            return this.inputMap.getChildByOrdinal(index);
        }

        public AbstractMapVector buildMap() {
            ValueVector vector;
            if (this.parentColumn.sourceIndex() != -1 && (vector = this.parentColumn.parent().vector(this.parentColumn.sourceIndex())) instanceof AbstractMapVector) {
                this.inputMap = (AbstractMapVector)vector;
            }
            MaterializedField colSchema = this.parentColumn.schema();
            this.outputMap = this.createMap(this.inputMap, MaterializedField.create(colSchema.getName(), colSchema.getType()), this.parentColumn.parent().allocator());
            this.buildColumns();
            return this.outputMap;
        }

        protected abstract AbstractMapVector createMap(AbstractMapVector var1, MaterializedField var2, BufferAllocator var3);

        @Override
        public BufferAllocator allocator() {
            return this.outputMap.getAllocator();
        }

        @Override
        public String name() {
            return this.parentColumn.name();
        }
    }

    public static class ResolvedRow
    extends ResolvedTuple {
        private VectorContainer input;
        private VectorContainer output;

        public ResolvedRow(NullColumnBuilder nullBuilder) {
            super(nullBuilder);
        }

        public void project(VectorContainer input, VectorContainer output) {
            this.input = input;
            this.output = output;
            output.removeAll();
            this.buildColumns();
            output.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }

        @Override
        public ValueVector vector(int index) {
            return this.input.getValueVector(index).getValueVector();
        }

        @Override
        public void addVector(ValueVector vector) {
            this.output.add(vector);
        }

        @Override
        public void setRowCount(int rowCount) {
            this.output.setRecordCount(rowCount);
            this.cascadeRowCount(rowCount);
        }

        @Override
        public BufferAllocator allocator() {
            return this.output.getAllocator();
        }

        @Override
        public String name() {
            return "$root$";
        }

        public VectorContainer output() {
            return this.output;
        }

        @Override
        public int innerCardinality(int rowCount) {
            return rowCount;
        }
    }
}

