/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedColumn;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.record.MaterializedField;

public class ResolvedDictColumn
extends ResolvedColumn {
    private final MaterializedField schema;
    private final ResolvedTuple parent;
    private final ResolvedTuple.ResolvedDict members;

    public ResolvedDictColumn(ResolvedTuple parent, String name) {
        super(parent, -1);
        this.schema = MaterializedField.create(name, Types.required(TypeProtos.MinorType.DICT));
        this.parent = parent;
        this.members = new ResolvedTuple.ResolvedSingleDict(this);
        parent.addChild(this.members);
    }

    public ResolvedDictColumn(ResolvedTuple parent, MaterializedField schema, int sourceIndex) {
        super(parent, sourceIndex);
        this.schema = schema;
        this.parent = parent;
        assert (schema.getType().getMinorType() == TypeProtos.MinorType.DICT);
        this.members = schema.getType().getMode() == TypeProtos.DataMode.REPEATED ? new ResolvedTuple.ResolvedDictArray(this) : new ResolvedTuple.ResolvedSingleDict(this);
        parent.addChild(this.members);
    }

    public ResolvedTuple parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.schema.getName();
    }

    public ResolvedTuple members() {
        return this.members;
    }

    @Override
    public void project(ResolvedTuple dest) {
        dest.addVector(this.members.buildVector());
    }

    @Override
    public MaterializedField schema() {
        return this.schema;
    }
}

