/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public abstract class ResolvedColumn
implements ColumnProjection {
    private final VectorSource source;
    private final int sourceIndex;
    private final ColumnMetadata outputCol;

    public ResolvedColumn(VectorSource source, int sourceIndex) {
        this.source = source;
        this.sourceIndex = sourceIndex;
        this.outputCol = null;
    }

    public ResolvedColumn(ColumnMetadata outputCol, VectorSource source, int sourceIndex) {
        this.source = source;
        this.sourceIndex = sourceIndex;
        this.outputCol = outputCol;
    }

    public VectorSource source() {
        return this.source;
    }

    public int sourceIndex() {
        return this.sourceIndex;
    }

    public ColumnMetadata metadata() {
        return this.outputCol;
    }

    public abstract MaterializedField schema();

    public void project(ResolvedTuple dest) {
        dest.addVector(this.source.vector(this.sourceIndex));
    }
}

