/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.project;

import java.util.List;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumn;
import org.apache.drill.exec.physical.impl.scan.file.FileMetadataColumnDefn;
import org.apache.drill.exec.physical.impl.scan.project.ColumnProjection;
import org.apache.drill.exec.physical.impl.scan.project.ExplicitSchemaProjection;
import org.apache.drill.exec.physical.impl.scan.project.NullColumnBuilder;
import org.apache.drill.exec.physical.impl.scan.project.ResolvedTuple;
import org.apache.drill.exec.physical.impl.scan.project.ScanSchemaOrchestrator;
import org.apache.drill.exec.physical.impl.scan.project.VectorSource;
import org.apache.drill.exec.physical.impl.scan.project.WildcardProjection;
import org.apache.drill.exec.physical.impl.scan.project.WildcardSchemaProjection;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetLoaderImpl;
import org.apache.drill.exec.physical.resultSet.impl.ResultSetOptionBuilder;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ReaderSchemaOrchestrator
implements VectorSource {
    private final ScanSchemaOrchestrator scanOrchestrator;
    private long limit;
    private int readerBatchSize;
    private ResultSetLoaderImpl tableLoader;
    private int prevTableSchemaVersion = -1;
    private ResolvedTuple.ResolvedRow rootTuple;
    private VectorContainer tableContainer;

    public ReaderSchemaOrchestrator(ScanSchemaOrchestrator scanSchemaOrchestrator, long limit) {
        this.scanOrchestrator = scanSchemaOrchestrator;
        this.limit = limit;
        this.readerBatchSize = this.scanOrchestrator.options.scanBatchRecordLimit;
    }

    public void setBatchSize(int size) {
        if (size > 0) {
            this.readerBatchSize = size;
        }
    }

    @VisibleForTesting
    public ResultSetLoader makeTableLoader(TupleMetadata readerSchema) {
        return this.makeTableLoader(this.scanOrchestrator.scanProj.context(), readerSchema, -1L);
    }

    public ResultSetLoader makeTableLoader(CustomErrorContext errorContext, TupleMetadata readerSchema, long localLimit) {
        ResultSetOptionBuilder options = new ResultSetOptionBuilder();
        options.rowCountLimit(Math.min(this.readerBatchSize, this.scanOrchestrator.options.scanBatchRecordLimit));
        options.vectorCache(this.scanOrchestrator.vectorCache);
        options.batchSizeLimit(this.scanOrchestrator.options.scanBatchByteLimit);
        options.errorContext(errorContext);
        options.projectionFilter(this.scanOrchestrator.scanProj.readerProjection);
        options.readerSchema(readerSchema);
        if (this.limit < 0L) {
            this.limit = localLimit;
        } else if (localLimit >= 0L) {
            this.limit = Math.min(localLimit, this.limit);
        }
        options.limit(this.limit);
        this.tableLoader = new ResultSetLoaderImpl(this.scanOrchestrator.allocator, options.build());
        return this.tableLoader;
    }

    public boolean hasSchema() {
        return this.prevTableSchemaVersion >= 0;
    }

    public void defineSchema() {
        this.tableLoader.startEmptyBatch();
        this.endBatch();
    }

    public boolean startBatch() {
        return this.tableLoader.startBatch();
    }

    public void endBatch() {
        this.endBatch(false);
    }

    public boolean endBatch(boolean eof) {
        this.tableContainer = this.tableLoader.harvest();
        boolean projected = this.resolveProjectingMetadata(eof);
        if (this.prevTableSchemaVersion < this.tableLoader.schemaVersion()) {
            this.reviseOutputProjection();
        } else {
            this.populateNonDataColumns();
        }
        if (projected) {
            this.projectMetadata(false);
        }
        int rowCount = this.tableContainer.getRecordCount();
        this.rootTuple.setRowCount(rowCount);
        this.scanOrchestrator.tallyBatch(rowCount);
        return eof || this.tableLoader.atLimit();
    }

    private boolean resolveProjectingMetadata(boolean eof) {
        if (this.tableContainer.getRecordCount() == 0 && !this.hasSchema() && eof && this.projectMetadata(true)) {
            this.tableContainer.setValueCount(this.tableContainer.getRecordCount() + 1);
            return true;
        }
        return false;
    }

    private boolean projectMetadata(boolean projectMetadata) {
        ColumnExplorer.ImplicitInternalFileColumns newColumn;
        ColumnExplorer.ImplicitInternalFileColumns original;
        if (projectMetadata) {
            original = ColumnExplorer.ImplicitInternalFileColumns.USE_METADATA;
            newColumn = ColumnExplorer.ImplicitInternalFileColumns.PROJECT_METADATA;
        } else {
            original = ColumnExplorer.ImplicitInternalFileColumns.PROJECT_METADATA;
            newColumn = ColumnExplorer.ImplicitInternalFileColumns.USE_METADATA;
        }
        List<ColumnProjection> outputColumns = this.scanOrchestrator.scanProj.columns();
        for (int i = 0; i < outputColumns.size(); ++i) {
            ColumnProjection outputColumn = outputColumns.get(i);
            if (!(outputColumn instanceof FileMetadataColumn)) continue;
            FileMetadataColumn metadataColumn = (FileMetadataColumn)outputColumn;
            if (metadataColumn.defn().defn != original) continue;
            projectMetadata = this.scanOrchestrator.scanProj.requestedCols().stream().anyMatch(SchemaPath.getSimplePath(metadataColumn.name())::equals);
            if (projectMetadata) {
                outputColumns.set(i, new FileMetadataColumn(metadataColumn.name(), new FileMetadataColumnDefn(metadataColumn.defn().colName(), newColumn)));
            }
            return projectMetadata;
        }
        return false;
    }

    private void populateNonDataColumns() {
        int rowCount = this.tableContainer.getRecordCount();
        this.scanOrchestrator.metadataManager.load(rowCount);
        this.rootTuple.loadNulls(rowCount);
    }

    private void reviseOutputProjection() {
        TupleMetadata readerSchema = this.tableLoader.outputSchema();
        if (this.scanOrchestrator.schemaSmoother != null) {
            this.doSmoothedProjection(readerSchema);
        } else {
            switch (this.scanOrchestrator.scanProj.projectionType()) {
                case EMPTY: 
                case EXPLICIT: {
                    this.doExplicitProjection(readerSchema);
                    break;
                }
                case SCHEMA_WILDCARD: 
                case STRICT_SCHEMA_WILDCARD: {
                    this.doStrictWildcardProjection(readerSchema);
                    break;
                }
                case WILDCARD: {
                    this.doWildcardProjection(readerSchema);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.scanOrchestrator.scanProj.projectionType().toString());
                }
            }
        }
        this.rootTuple.buildNulls(this.scanOrchestrator.vectorCache);
        this.scanOrchestrator.metadataManager.define();
        this.populateNonDataColumns();
        this.rootTuple.project(this.tableContainer, this.scanOrchestrator.outputContainer);
        this.prevTableSchemaVersion = this.tableLoader.schemaVersion();
    }

    private void doSmoothedProjection(TupleMetadata tableSchema) {
        this.rootTuple = this.newRootTuple();
        this.scanOrchestrator.schemaSmoother.resolve(tableSchema, this.rootTuple);
    }

    private void doWildcardProjection(TupleMetadata tableSchema) {
        this.rootTuple = this.newRootTuple();
        new WildcardProjection(this.scanOrchestrator.scanProj, tableSchema, this.rootTuple, this.scanOrchestrator.options.schemaResolvers);
    }

    private void doStrictWildcardProjection(TupleMetadata tableSchema) {
        this.rootTuple = this.newRootTuple();
        new WildcardSchemaProjection(this.scanOrchestrator.scanProj, tableSchema, this.rootTuple, this.scanOrchestrator.options.schemaResolvers);
    }

    private ResolvedTuple.ResolvedRow newRootTuple() {
        return new ResolvedTuple.ResolvedRow(new NullColumnBuilder.NullBuilderBuilder().setNullType(this.scanOrchestrator.options.nullType).allowRequiredNullColumns(this.scanOrchestrator.options.allowRequiredNullColumns).setOutputSchema(this.scanOrchestrator.options.providedSchema()).build());
    }

    private void doExplicitProjection(TupleMetadata tableSchema) {
        this.rootTuple = this.newRootTuple();
        new ExplicitSchemaProjection(this.scanOrchestrator.scanProj, tableSchema, this.rootTuple, this.scanOrchestrator.options.schemaResolvers);
    }

    @Override
    public ValueVector vector(int index) {
        return this.tableContainer.getValueVector(index).getValueVector();
    }

    public void close() {
        RuntimeException ex = null;
        try {
            if (this.tableLoader != null) {
                this.tableLoader.close();
                this.tableLoader = null;
            }
        }
        catch (RuntimeException e) {
            ex = e;
        }
        try {
            if (this.rootTuple != null) {
                this.rootTuple.close();
                this.rootTuple = null;
            }
        }
        catch (RuntimeException e) {
            ex = ex == null ? e : ex;
        }
        this.scanOrchestrator.metadataManager.endFile();
        if (ex != null) {
            throw ex;
        }
    }
}

