/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.scan.framework;

import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.RowBatchReader;
import org.apache.drill.exec.physical.impl.scan.ScanOperatorEvents;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiatorImpl;
import org.apache.drill.exec.physical.impl.scan.framework.ShimBatchReader;
import org.apache.drill.exec.physical.impl.scan.project.ScanSchemaOrchestrator;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedScanFramework
implements ScanOperatorEvents {
    static final Logger logger = LoggerFactory.getLogger(ManagedScanFramework.class);
    protected final ScanFrameworkBuilder builder;
    protected final ReaderFactory readerFactory;
    protected OperatorContext context;
    protected ScanSchemaOrchestrator scanOrchestrator;

    public ManagedScanFramework(ScanFrameworkBuilder builder) {
        this.builder = builder;
        this.readerFactory = builder.readerFactory;
        assert (this.readerFactory != null);
    }

    @Override
    public void bind(OperatorContext context) {
        this.context = context;
        this.configure();
        this.scanOrchestrator = new ScanSchemaOrchestrator(context.getAllocator(), this.builder);
        this.readerFactory.bind(this);
    }

    public OperatorContext context() {
        return this.context;
    }

    public ScanSchemaOrchestrator scanOrchestrator() {
        return this.scanOrchestrator;
    }

    public TupleMetadata outputSchema() {
        return this.scanOrchestrator.providedSchema();
    }

    public CustomErrorContext errorContext() {
        return this.builder.errorContext();
    }

    protected void configure() {
    }

    @Override
    public RowBatchReader nextReader() {
        if (this.scanOrchestrator.atLimit()) {
            return null;
        }
        ManagedReader<? extends SchemaNegotiator> reader = this.readerFactory.next();
        return reader == null ? null : new ShimBatchReader(this, reader);
    }

    protected SchemaNegotiatorImpl newNegotiator() {
        return new SchemaNegotiatorImpl(this);
    }

    public boolean open(ShimBatchReader shimBatchReader) {
        SchemaNegotiatorImpl schemaNegotiator = this.newNegotiator();
        schemaNegotiator.bind(shimBatchReader);
        return shimBatchReader.reader().open(schemaNegotiator);
    }

    @Override
    public void close() {
        if (this.scanOrchestrator != null) {
            this.scanOrchestrator.close();
            this.scanOrchestrator = null;
        }
    }

    public static class ScanFrameworkBuilder
    extends ScanSchemaOrchestrator.ScanOrchestratorBuilder {
        protected ReaderFactory readerFactory;
        protected String userName;

        public void setReaderFactory(ReaderFactory readerFactory) {
            this.readerFactory = readerFactory;
        }

        public ReaderFactory readerFactory() {
            return this.readerFactory;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public ScanOperatorEvents buildEvents() {
            return new ManagedScanFramework(this);
        }
    }

    public static interface ReaderFactory {
        public void bind(ManagedScanFramework var1);

        public ManagedReader<? extends SchemaNegotiator> next();
    }
}

